/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts;

import java.util.Map;
import org.joda.time.DateTime;

public interface Alert {
    public String getId();

    public String getStreamId();

    public String getConditionId();

    public DateTime getTriggeredAt();

    public DateTime getResolvedAt();

    public String getDescription();

    public Map<String, Object> getConditionParameters();

    public boolean isInterval();

    public static enum AlertState {
        ANY,
        RESOLVED,
        UNRESOLVED;


        public static AlertState fromString(String state) {
            for (AlertState aState : AlertState.values()) {
                if (!aState.toString().equalsIgnoreCase(state)) continue;
                return aState;
            }
            throw new IllegalArgumentException("Alert state " + state + " is not supported");
        }
    }
}

