/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.ValidatorMethod;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;
import com.github.joschi.jadconfig.validators.StringNotBlankValidator;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;

public class MongoDbConfiguration {
    @Parameter(value="mongodb_max_connections", validator=PositiveIntegerValidator.class)
    private int maxConnections = 1000;
    @Parameter(value="mongodb_threads_allowed_to_block_multiplier", validator=PositiveIntegerValidator.class)
    private int threadsAllowedToBlockMultiplier = 5;
    @Parameter(value="mongodb_uri", required=true, validator=StringNotBlankValidator.class)
    private String uri = "mongodb://localhost/graylog";

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getThreadsAllowedToBlockMultiplier() {
        return this.threadsAllowedToBlockMultiplier;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public MongoClientURI getMongoClientURI() {
        MongoClientOptions.Builder mongoClientOptionsBuilder = MongoClientOptions.builder().connectionsPerHost(this.getMaxConnections()).threadsAllowedToBlockForConnectionMultiplier(this.getThreadsAllowedToBlockMultiplier());
        return new MongoClientURI(this.uri, mongoClientOptionsBuilder);
    }

    @ValidatorMethod
    public void validate() throws ValidationException {
        if (this.getMongoClientURI() == null) {
            throw new ValidationException("mongodb_uri is not a valid MongoDB connection string");
        }
    }
}

