/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.GlobalOverride;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog2.contentpacks.model.entities.QueryEntity;
import org.graylog2.contentpacks.model.entities.SearchTypeEntity;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

final class AutoValue_QueryEntity
extends QueryEntity {
    private final String id;
    private final TimeRange timerange;
    private final Filter filter;
    private final BackendQuery query;
    private final Optional<GlobalOverride> globalOverride;
    private final ImmutableSet<SearchTypeEntity> searchTypes;

    private AutoValue_QueryEntity(String id, TimeRange timerange, @Nullable Filter filter, BackendQuery query, Optional<GlobalOverride> globalOverride, ImmutableSet<SearchTypeEntity> searchTypes) {
        this.id = id;
        this.timerange = timerange;
        this.filter = filter;
        this.query = query;
        this.globalOverride = globalOverride;
        this.searchTypes = searchTypes;
    }

    @Override
    @JsonProperty
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty
    public TimeRange timerange() {
        return this.timerange;
    }

    @Override
    @Nullable
    @JsonProperty
    public Filter filter() {
        return this.filter;
    }

    @Override
    @Nonnull
    @JsonProperty
    public BackendQuery query() {
        return this.query;
    }

    @Override
    @JsonIgnore
    public Optional<GlobalOverride> globalOverride() {
        return this.globalOverride;
    }

    @Override
    @Nonnull
    @JsonProperty(value="search_types")
    public ImmutableSet<SearchTypeEntity> searchTypes() {
        return this.searchTypes;
    }

    public String toString() {
        return "QueryEntity{id=" + this.id + ", timerange=" + this.timerange + ", filter=" + this.filter + ", query=" + this.query + ", globalOverride=" + this.globalOverride + ", searchTypes=" + this.searchTypes + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof QueryEntity) {
            QueryEntity that = (QueryEntity)o;
            return this.id.equals(that.id()) && this.timerange.equals(that.timerange()) && (this.filter == null ? that.filter() == null : this.filter.equals(that.filter())) && this.query.equals(that.query()) && this.globalOverride.equals(that.globalOverride()) && this.searchTypes.equals(that.searchTypes());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.id.hashCode();
        h$ *= 1000003;
        h$ ^= this.timerange.hashCode();
        h$ *= 1000003;
        h$ ^= this.filter == null ? 0 : this.filter.hashCode();
        h$ *= 1000003;
        h$ ^= this.query.hashCode();
        h$ *= 1000003;
        h$ ^= this.globalOverride.hashCode();
        h$ *= 1000003;
        return h$ ^= this.searchTypes.hashCode();
    }

    @Override
    public QueryEntity.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends QueryEntity.Builder {
        private String id;
        private TimeRange timerange;
        private Filter filter;
        private BackendQuery query;
        private Optional<GlobalOverride> globalOverride = Optional.empty();
        private ImmutableSet<SearchTypeEntity> searchTypes;

        Builder() {
        }

        private Builder(QueryEntity source) {
            this.id = source.id();
            this.timerange = source.timerange();
            this.filter = source.filter();
            this.query = source.query();
            this.globalOverride = source.globalOverride();
            this.searchTypes = source.searchTypes();
        }

        @Override
        public QueryEntity.Builder id(String id) {
            if (id == null) {
                throw new NullPointerException("Null id");
            }
            this.id = id;
            return this;
        }

        @Override
        public QueryEntity.Builder timerange(TimeRange timerange) {
            if (timerange == null) {
                throw new NullPointerException("Null timerange");
            }
            this.timerange = timerange;
            return this;
        }

        @Override
        public QueryEntity.Builder filter(Filter filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public QueryEntity.Builder query(BackendQuery query) {
            if (query == null) {
                throw new NullPointerException("Null query");
            }
            this.query = query;
            return this;
        }

        @Override
        public QueryEntity.Builder globalOverride(@Nullable GlobalOverride globalOverride) {
            this.globalOverride = Optional.ofNullable(globalOverride);
            return this;
        }

        @Override
        public QueryEntity.Builder searchTypes(@Nullable Set<SearchTypeEntity> searchTypes) {
            this.searchTypes = ImmutableSet.copyOf(searchTypes);
            return this;
        }

        @Override
        QueryEntity autoBuild() {
            String missing = "";
            if (this.id == null) {
                missing = missing + " id";
            }
            if (this.timerange == null) {
                missing = missing + " timerange";
            }
            if (this.query == null) {
                missing = missing + " query";
            }
            if (this.searchTypes == null) {
                missing = missing + " searchTypes";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_QueryEntity(this.id, this.timerange, this.filter, this.query, this.globalOverride, this.searchTypes);
        }
    }
}

