/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.messages;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.messages.IndexingRequest;
import org.graylog2.indexer.messages.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkedBulkIndexer {
    private static final Logger LOG = LoggerFactory.getLogger(ChunkedBulkIndexer.class);

    public List<Messages.IndexingError> index(List<IndexingRequest> messageList, BulkIndex bulkIndex) throws IOException {
        if (messageList.isEmpty()) {
            return Collections.emptyList();
        }
        int chunkSize = messageList.size();
        int offset = 0;
        while (true) {
            try {
                return bulkIndex.apply(new Chunk(messageList, offset, chunkSize));
            }
            catch (EntityTooLargeException e) {
                LOG.warn("Bulk index failed with 'Request Entity Too Large' error. Retrying by splitting up batch size <{}>.", (Object)chunkSize);
                if (chunkSize == messageList.size()) {
                    LOG.warn("Consider lowering the \"output_batch_size\" setting.");
                }
                offset += e.indexedSuccessfully;
                if ((chunkSize /= 2) != 0) continue;
                throw new ElasticsearchException("Bulk index cannot split output batch any further.");
            }
            break;
        }
    }

    public static class EntityTooLargeException
    extends Exception {
        public final int indexedSuccessfully;
        public final List<Messages.IndexingError> failedItems;

        public EntityTooLargeException(int indexedSuccessfully, List<Messages.IndexingError> failedItems) {
            this.indexedSuccessfully = indexedSuccessfully;
            this.failedItems = failedItems;
        }
    }

    public static class Chunk {
        public final List<IndexingRequest> requests;
        public final int offset;
        public final int size;

        Chunk(List<IndexingRequest> requests, int offset, int size) {
            this.requests = requests;
            this.offset = offset;
            this.size = size;
        }
    }

    public static interface BulkIndex {
        public List<Messages.IndexingError> apply(Chunk var1) throws EntityTooLargeException, IOException;
    }
}

