/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.converters;

import com.google.common.primitives.Ints;
import java.util.Map;
import org.graylog2.inputs.converters.SyslogPriUtilities;
import org.graylog2.plugin.inputs.Converter;

public class SyslogPriLevelConverter
extends Converter {
    public SyslogPriLevelConverter(Map<String, Object> config) {
        super(Converter.Type.SYSLOG_PRI_LEVEL, config);
    }

    @Override
    public Object convert(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        Integer priority = Ints.tryParse((String)value);
        if (priority == null) {
            return value;
        }
        return SyslogPriUtilities.levelFromPriority(priority);
    }

    @Override
    public boolean buildsMultipleFields() {
        return false;
    }
}

