/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.extractors;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import io.krakens.grok.api.Grok;
import io.krakens.grok.api.Match;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.graylog2.ConfigurationException;
import org.graylog2.grok.GrokPatternRegistry;
import org.graylog2.plugin.inputs.Converter;
import org.graylog2.plugin.inputs.Extractor;

public class GrokExtractor
extends Extractor {
    public static final String CONFIG_GROK_PATTERN = "grok_pattern";
    private GrokPatternRegistry grokPatternRegistry;
    private String pattern;
    private boolean namedCapturesOnly;

    GrokExtractor(MetricRegistry metricRegistry, GrokPatternRegistry grokPatternRegistry, String id, String title, long order, Extractor.CursorStrategy cursorStrategy, String sourceField, String targetField, Map<String, Object> extractorConfig, String creatorUserId, List<Converter> converters, Extractor.ConditionType conditionType, String conditionValue) throws Extractor.ReservedFieldException, ConfigurationException {
        super(metricRegistry, id, title, order, Extractor.Type.GROK, cursorStrategy, sourceField, targetField, extractorConfig, creatorUserId, converters, conditionType, conditionValue);
        if (extractorConfig == null || Strings.isNullOrEmpty((String)((String)extractorConfig.get(CONFIG_GROK_PATTERN)))) {
            throw new ConfigurationException("grok_pattern not set");
        }
        this.grokPatternRegistry = grokPatternRegistry;
        this.pattern = (String)extractorConfig.get(CONFIG_GROK_PATTERN);
        this.namedCapturesOnly = (Boolean)extractorConfig.getOrDefault("named_captures_only", false);
    }

    @Override
    protected Extractor.Result[] run(String value) {
        Grok grok = this.grokPatternRegistry.cachedGrokForPattern(this.pattern, this.namedCapturesOnly);
        Match match = grok.match((CharSequence)value);
        Map matches = match.captureFlattened();
        ArrayList<Extractor.Result> results = new ArrayList<Extractor.Result>(matches.size());
        for (Map.Entry entry : matches.entrySet()) {
            if (entry.getValue() == null) continue;
            results.add(new Extractor.Result(entry.getValue(), (String)entry.getKey(), -1, -1));
        }
        return results.toArray(new Extractor.Result[0]);
    }
}

