/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.mongodb.DuplicateKeyException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.users.Role;
import org.graylog2.shared.users.UserService;
import org.graylog2.users.RoleImpl;
import org.graylog2.users.RoleService;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationHelpers {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationHelpers.class);
    private final RoleService roleService;
    private final UserService userService;

    @Inject
    public MigrationHelpers(RoleService roleService, UserService userService) {
        this.roleService = roleService;
        this.userService = userService;
    }

    @Nullable
    public String ensureBuiltinRole(String roleName, String description, Set<String> expectedPermissions) {
        Role previousRole = null;
        try {
            previousRole = this.roleService.load(roleName);
            if (!previousRole.isReadOnly() || !expectedPermissions.equals(previousRole.getPermissions())) {
                String msg = "Invalid role '" + roleName + "', fixing it.";
                LOG.error(msg);
                throw new IllegalArgumentException(msg);
            }
        }
        catch (IllegalArgumentException | NoSuchElementException | NotFoundException ignored) {
            LOG.info("{} role is missing or invalid, re-adding it as a built-in role.", (Object)roleName);
            RoleImpl fixedRole = new RoleImpl();
            if (previousRole != null) {
                fixedRole._id = previousRole.getId();
            }
            fixedRole.setReadOnly(true);
            fixedRole.setName(roleName);
            fixedRole.setDescription(description);
            fixedRole.setPermissions(expectedPermissions);
            try {
                Role savedRole = this.roleService.save(fixedRole);
                return savedRole.getId();
            }
            catch (DuplicateKeyException | ValidationException e) {
                LOG.error("Unable to save fixed '" + roleName + "' role, please restart Graylog to fix this.", e);
            }
        }
        if (previousRole == null) {
            LOG.error("Unable to access fixed '" + roleName + "' role, please restart Graylog to fix this.");
            return null;
        }
        return previousRole.getId();
    }

    @Nullable
    public String ensureUser(String userName, String password, String fullName, String email, Set<String> expectedRoles) {
        User previousUser = null;
        try {
            previousUser = this.userService.load(userName);
            if (previousUser == null || !previousUser.getRoleIds().containsAll(expectedRoles)) {
                String msg = "Invalid user '" + userName + "', fixing it.";
                LOG.error(msg);
                throw new IllegalArgumentException(msg);
            }
        }
        catch (IllegalArgumentException ignored) {
            User fixedUser;
            LOG.info("{} user is missing or invalid, re-adding it as a built-in user.", (Object)userName);
            if (previousUser != null) {
                fixedUser = previousUser;
                fixedUser.setRoleIds(expectedRoles);
            } else {
                fixedUser = this.userService.create();
                fixedUser.setName(userName);
                fixedUser.setFullName(fullName);
                fixedUser.setPassword(password);
                fixedUser.setEmail(email);
                fixedUser.setPermissions(Collections.emptyList());
                fixedUser.setRoleIds(expectedRoles);
                fixedUser.setTimeZone(DateTimeZone.UTC);
            }
            try {
                return this.userService.save(fixedUser);
            }
            catch (ValidationException e) {
                LOG.error("Unable to save fixed '" + userName + "' user, please restart Graylog to fix this.", (Throwable)e);
            }
        }
        if (previousUser == null) {
            LOG.error("Unable to access fixed '" + userName + "' user, please restart Graylog to fix this.");
            return null;
        }
        return previousUser.getId();
    }
}

