/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.auto.value.AutoValue;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.graylog.events.processor.DBEventDefinitionService;
import org.graylog.events.processor.EventDefinitionDto;
import org.graylog.events.processor.aggregation.AggregationConditions;
import org.graylog.events.processor.aggregation.AggregationEventProcessorConfig;
import org.graylog2.migrations.AutoValue_V20200102140000_UnifyEventSeriesId_MigrationCompleted;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.shared.bindings.providers.ObjectMapperProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20200102140000_UnifyEventSeriesId
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20200102140000_UnifyEventSeriesId.class);
    private final ClusterConfigService clusterConfigService;
    private final DBEventDefinitionService eventDefinitionService;
    private final ObjectMapperProvider objectMapperProvider;

    @Inject
    public V20200102140000_UnifyEventSeriesId(ClusterConfigService clusterConfigService, DBEventDefinitionService eventDefinitionService, ObjectMapperProvider objectMapperProvider) {
        this.clusterConfigService = clusterConfigService;
        this.eventDefinitionService = eventDefinitionService;
        this.objectMapperProvider = objectMapperProvider;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2020-01-02T14:00:00Z");
    }

    @Override
    public void upgrade() {
        List changedEventDefinitions;
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed.");
            return;
        }
        try (Stream dtoStream = this.eventDefinitionService.streamAll();){
            changedEventDefinitions = dtoStream.map(this::unifySeriesId).filter(Objects::nonNull).collect(Collectors.toList());
        }
        for (EventDefinitionDto changedDto : changedEventDefinitions) {
            LOG.info("Unified series Id for EventDefinition <{}>", (Object)changedDto.id());
            this.eventDefinitionService.save(changedDto);
        }
        this.clusterConfigService.write(MigrationCompleted.create());
    }

    private EventDefinitionDto unifySeriesId(EventDefinitionDto dto) {
        if (!dto.config().type().equals("aggregation-v1")) {
            return null;
        }
        AggregationEventProcessorConfig config = (AggregationEventProcessorConfig)dto.config();
        if (config.series().isEmpty()) {
            return null;
        }
        ObjectMapper objectMapper = this.objectMapperProvider.get();
        AggregationEventProcessorConfig.Builder configBuilder = config.toBuilder();
        HashMap<String, String> refMap = new HashMap<String, String>();
        configBuilder.series(config.series().stream().map(s -> {
            String newId = s.function().toSeriesId(s.field());
            refMap.put(s.id(), newId);
            return s.toBuilder().id(newId).build();
        }).collect(Collectors.toList()));
        JsonNode conditionsJson = objectMapper.valueToTree(config.conditions());
        this.convertConditions(dto.id(), refMap, conditionsJson);
        AggregationConditions convertedConditions = (AggregationConditions)objectMapper.convertValue((Object)conditionsJson, AggregationConditions.class);
        configBuilder.conditions(convertedConditions);
        return dto.toBuilder().config(configBuilder.build()).build();
    }

    private void convertConditions(String eventId, Map<String, String> changedIds, JsonNode jsonNode) {
        ObjectNode objectNode;
        if (jsonNode.isObject() && (objectNode = (ObjectNode)jsonNode).get("expr") != null && objectNode.get("expr").asText().equals("number-ref")) {
            String newRef = changedIds.get(objectNode.get("ref").asText());
            if (newRef == null) {
                throw new RuntimeException(String.format(Locale.US, "Could not resolve new ref for condition on EventDefinition <%s>. oldref <%s> refMap <%s>", eventId, objectNode.get("ref"), changedIds));
            }
            objectNode.put("ref", newRef);
        }
        jsonNode.fields().forEachRemaining(f -> {
            JsonNode value = (JsonNode)f.getValue();
            if (value.isContainerNode()) {
                this.convertConditions(eventId, changedIds, value);
            }
        });
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonCreator
        public static MigrationCompleted create() {
            return new AutoValue_V20200102140000_UnifyEventSeriesId_MigrationCompleted();
        }
    }
}

