/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations.V20200803120800_GrantsMigrations;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.graylog.grn.GRNRegistry;
import org.graylog.grn.GRNType;
import org.graylog.security.Capability;
import org.graylog.security.DBGrantService;
import org.graylog2.migrations.V20200803120800_GrantsMigrations.GrantsMetaMigration;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.users.Role;
import org.graylog2.shared.users.UserService;
import org.graylog2.users.RoleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RolesToGrantsMigration {
    private static final Logger LOG = LoggerFactory.getLogger(RolesToGrantsMigration.class);
    private final RoleService roleService;
    private final UserService userService;
    private final DBGrantService dbGrantService;
    private final GRNRegistry grnRegistry;
    private final String rootUsername;

    public RolesToGrantsMigration(RoleService roleService, UserService userService, DBGrantService dbGrantService, GRNRegistry grnRegistry, @Named(value="root_username") String rootUsername) {
        this.roleService = roleService;
        this.userService = userService;
        this.dbGrantService = dbGrantService;
        this.grnRegistry = grnRegistry;
        this.rootUsername = rootUsername;
    }

    public void upgrade() {
        Set<MigratableRole> migratableRoles = this.findMigratableRoles();
        migratableRoles.forEach(migratableRole -> {
            Role role = migratableRole.role;
            Set<String> migratedPermissions = this.migrateRoleToGrant((MigratableRole)migratableRole);
            if (role.getPermissions().removeAll(migratedPermissions)) {
                LOG.debug("Updating role <{}> new permissions: <{}>", (Object)role.getName(), role.getPermissions());
                if (role.getPermissions().isEmpty()) {
                    LOG.info("Removing the now empty role <{}>", (Object)role.getName());
                    this.userService.dissociateAllUsersFromRole(role);
                    this.roleService.delete(role.getName());
                } else {
                    try {
                        this.roleService.save(role);
                    }
                    catch (ValidationException e) {
                        LOG.error("Failed to update modified role <{}>", (Object)role.getName(), (Object)e);
                    }
                }
            }
        });
    }

    private Set<String> migrateRoleToGrant(MigratableRole migratableRole) {
        HashSet<String> migratedRolePermissions = new HashSet<String>();
        Collection<User> allRoleUsers = this.userService.loadAllForRole(migratableRole.role);
        migratableRole.migratableEntities.forEach((entityID, permissions) -> {
            GrantsMetaMigration.GRNTypeCapability grnTypeCapability = GrantsMetaMigration.MIGRATION_MAP.get(permissions);
            if (grnTypeCapability != null) {
                Capability capability = grnTypeCapability.capability;
                GRNType grnType = grnTypeCapability.grnType;
                allRoleUsers.forEach(user -> {
                    this.dbGrantService.ensure(this.grnRegistry.ofUser((User)user), capability, grnType.toGRN((String)entityID), this.rootUsername);
                    LOG.info("Migrating entity <{}> permissions <{}> to <{}> grant for user <{}>", new Object[]{grnType.toGRN((String)entityID), permissions, capability, user.getName()});
                });
                migratedRolePermissions.addAll(permissions.stream().map(p -> p + ":" + entityID).collect(Collectors.toSet()));
            } else {
                LOG.info("Skipping non-migratable entity <{}>. Permissions <{}> cannot be converted to a grant capability", entityID, permissions);
            }
        });
        return migratedRolePermissions;
    }

    private Set<MigratableRole> findMigratableRoles() {
        HashSet<MigratableRole> migratableRoles = new HashSet<MigratableRole>();
        Set<Role> roles = this.roleService.loadAll();
        roles.forEach(role -> {
            HashMap<String, Set<String>> migratableIds = new HashMap<String, Set<String>>();
            role.getPermissions().stream().map(GrantsMetaMigration.MigrationWildcardPermission::new).filter(p -> p.getParts().size() == 3 && p.getParts().stream().allMatch(part -> part.size() == 1)).forEach(p -> {
                String permissionType = p.subPart(0);
                String restPermission = p.subPart(0) + ":" + p.subPart(1);
                String id = p.subPart(2);
                if (GrantsMetaMigration.MIGRATION_MAP.keySet().stream().flatMap(Collection::stream).anyMatch(perm -> perm.startsWith(permissionType + ":"))) {
                    LOG.debug("Potentially migratable role <{}> permission <{}> id <{}>", new Object[]{role.getName(), restPermission, id});
                    if (migratableIds.containsKey(id)) {
                        ((Set)migratableIds.get(id)).add(restPermission);
                    } else {
                        migratableIds.put(id, Sets.newHashSet((Object[])new String[]{restPermission}));
                    }
                }
            });
            if (!migratableIds.isEmpty()) {
                migratableRoles.add(new MigratableRole((Role)role, (Map<String, Set<String>>)migratableIds));
            }
        });
        LOG.debug("migratableRoles <{}>", migratableRoles);
        return migratableRoles;
    }

    private static class MigratableRole {
        Role role;
        Map<String, Set<String>> migratableEntities;

        public MigratableRole(Role role, Map<String, Set<String>> migratableEntities) {
            this.role = role;
            this.migratableEntities = migratableEntities;
        }

        public String toString() {
            return "MigratableRole{roleID='" + this.role.getId() + '\'' + ", migratableIds=" + this.migratableEntities + '}';
        }
    }
}

