/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import java.net.URI;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.Version;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.storage.ElasticsearchVersion;
import org.graylog2.storage.versionprobe.VersionProbe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESVersionCheckPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(ESVersionCheckPeriodical.class);
    private final Version initialElasticsearchVersion;
    private final Optional<Version> versionOverride;
    private final List<URI> elasticsearchHosts;
    private final VersionProbe versionProbe;
    private final NotificationService notificationService;

    @Inject
    public ESVersionCheckPeriodical(@ElasticsearchVersion Version elasticsearchVersion, @Named(value="elasticsearch_version") @Nullable Version versionOverride, @Named(value="elasticsearch_hosts") List<URI> elasticsearchHosts, VersionProbe versionProbe, NotificationService notificationService) {
        this.initialElasticsearchVersion = elasticsearchVersion;
        this.versionOverride = Optional.ofNullable(versionOverride);
        this.elasticsearchHosts = elasticsearchHosts;
        this.versionProbe = versionProbe;
        this.notificationService = notificationService;
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean masterOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 30;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void doRun() {
        if (this.versionOverride.isPresent()) {
            LOG.debug("Elasticsearch version is set manually. Not running check.");
            return;
        }
        Optional<Version> probedVersion = this.versionProbe.probe(this.elasticsearchHosts);
        probedVersion.ifPresent(version -> {
            if (this.compatible(this.initialElasticsearchVersion, (Version)version)) {
                this.notificationService.fixed(Notification.Type.ES_VERSION_MISMATCH);
            } else {
                LOG.warn("Elasticsearch version currently running ({}) is incompatible with the one Graylog was started with ({}) - a restart is required!", version, (Object)this.initialElasticsearchVersion);
                Notification notification = this.notificationService.buildNow().addType(Notification.Type.ES_VERSION_MISMATCH).addSeverity(Notification.Severity.URGENT).addDetail("initial_version", this.initialElasticsearchVersion.toString()).addDetail("current_version", version.toString());
                this.notificationService.publishIfFirst(notification);
            }
        });
    }

    private boolean compatible(Version initialElasticsearchMajorVersion, Version version) {
        return initialElasticsearchMajorVersion.getVersion().getMajorVersion() == version.getVersion().getMajorVersion();
    }
}

