/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.indexer.cluster.health.AbsoluteValueWatermarkSettings;
import org.graylog2.indexer.cluster.health.ClusterAllocationDiskSettings;
import org.graylog2.indexer.cluster.health.NodeDiskUsageStats;
import org.graylog2.indexer.cluster.health.NodeFileDescriptorStats;
import org.graylog2.indexer.cluster.health.PercentageWatermarkSettings;
import org.graylog2.indexer.cluster.health.WatermarkSettings;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexerClusterCheckerThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(IndexerClusterCheckerThread.class);
    private static final int MINIMUM_OPEN_FILES_LIMIT = 64000;
    private final NotificationService notificationService;
    private final Cluster cluster;

    @Inject
    public IndexerClusterCheckerThread(NotificationService notificationService, Cluster cluster) {
        this.notificationService = notificationService;
        this.cluster = cluster;
    }

    @Override
    public void doRun() {
        if (!this.cluster.health().isPresent()) {
            LOG.info("Indexer not fully initialized yet. Skipping periodic cluster check.");
            return;
        }
        this.checkOpenFiles();
        this.checkDiskUsage();
    }

    @VisibleForTesting
    void checkOpenFiles() {
        if (this.notificationExists(Notification.Type.ES_OPEN_FILES)) {
            return;
        }
        boolean allHigher = true;
        Set<NodeFileDescriptorStats> fileDescriptorStats = this.cluster.getFileDescriptorStats();
        for (NodeFileDescriptorStats nodeFileDescriptorStats : fileDescriptorStats) {
            String name = nodeFileDescriptorStats.name();
            String ip = nodeFileDescriptorStats.ip();
            String host = nodeFileDescriptorStats.host();
            long maxFileDescriptors = nodeFileDescriptorStats.fileDescriptorMax().orElse(-1L);
            if (maxFileDescriptors == -1L || maxFileDescriptors >= 64000L) continue;
            String ipOrHostName = (String)MoreObjects.firstNonNull((Object)host, (Object)ip);
            Notification notification = this.notificationService.buildNow().addType(Notification.Type.ES_OPEN_FILES).addSeverity(Notification.Severity.URGENT).addDetail("hostname", ipOrHostName).addDetail("max_file_descriptors", maxFileDescriptors);
            if (this.notificationService.publishIfFirst(notification)) {
                LOG.warn("Indexer node <{}> ({}) open file limit is too low: [{}]. Set it to at least {}.", new Object[]{name, ipOrHostName, maxFileDescriptors, 64000});
            }
            allHigher = false;
        }
        if (allHigher) {
            Notification notification = this.notificationService.build().addType(Notification.Type.ES_OPEN_FILES);
            this.notificationService.fixed(notification);
        }
    }

    @VisibleForTesting
    void checkDiskUsage() {
        HashMap<Notification.Type, List<String>> notificationTypePerNodeIdentifier = new HashMap<Notification.Type, List<String>>();
        try {
            ClusterAllocationDiskSettings settings = this.cluster.getClusterAllocationDiskSettings();
            if (settings.ThresholdEnabled()) {
                Set<NodeDiskUsageStats> diskUsageStats = this.cluster.getDiskUsageStats();
                for (NodeDiskUsageStats nodeDiskUsageStats : diskUsageStats) {
                    Notification.Type currentNodeNotificationType = null;
                    WatermarkSettings<?> watermarkSettings = settings.watermarkSettings();
                    if (watermarkSettings instanceof PercentageWatermarkSettings) {
                        currentNodeNotificationType = this.getDiskUsageNotificationTypeByPercentage((PercentageWatermarkSettings)watermarkSettings, nodeDiskUsageStats);
                    } else if (watermarkSettings instanceof AbsoluteValueWatermarkSettings) {
                        currentNodeNotificationType = this.getDiskUsageNotificationTypeByAbsoluteValues((AbsoluteValueWatermarkSettings)watermarkSettings, nodeDiskUsageStats);
                    }
                    if (currentNodeNotificationType == null) continue;
                    String nodeIdentifier = (String)MoreObjects.firstNonNull((Object)nodeDiskUsageStats.host(), (Object)nodeDiskUsageStats.ip());
                    if (notificationTypePerNodeIdentifier.containsKey((Object)currentNodeNotificationType)) {
                        List nodesIdentifier = (List)notificationTypePerNodeIdentifier.get((Object)currentNodeNotificationType);
                        nodesIdentifier.add(nodeIdentifier);
                        continue;
                    }
                    notificationTypePerNodeIdentifier.put(currentNodeNotificationType, Arrays.asList(nodeIdentifier));
                }
                if (notificationTypePerNodeIdentifier.isEmpty()) {
                    this.fixAllDiskUsageNotifications();
                } else {
                    this.publishDiskUsageNotifications(notificationTypePerNodeIdentifier);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error while trying to check Elasticsearch disk usage.Details: " + e.getMessage());
        }
    }

    private Notification.Type getDiskUsageNotificationTypeByPercentage(PercentageWatermarkSettings settings, NodeDiskUsageStats nodeDiskUsageStats) {
        if (settings.floodStage() != null && nodeDiskUsageStats.diskUsedPercent() >= settings.floodStage()) {
            return Notification.Type.ES_NODE_DISK_WATERMARK_FLOOD_STAGE;
        }
        if (nodeDiskUsageStats.diskUsedPercent() >= settings.high()) {
            return Notification.Type.ES_NODE_DISK_WATERMARK_HIGH;
        }
        if (nodeDiskUsageStats.diskUsedPercent() >= settings.low()) {
            return Notification.Type.ES_NODE_DISK_WATERMARK_LOW;
        }
        return null;
    }

    private Notification.Type getDiskUsageNotificationTypeByAbsoluteValues(AbsoluteValueWatermarkSettings settings, NodeDiskUsageStats nodeDiskUsageStats) {
        if (settings.floodStage() != null && nodeDiskUsageStats.diskAvailable().getBytes() <= settings.floodStage().getBytes()) {
            return Notification.Type.ES_NODE_DISK_WATERMARK_FLOOD_STAGE;
        }
        if (nodeDiskUsageStats.diskAvailable().getBytes() <= settings.high().getBytes()) {
            return Notification.Type.ES_NODE_DISK_WATERMARK_HIGH;
        }
        if (nodeDiskUsageStats.diskAvailable().getBytes() <= settings.low().getBytes()) {
            return Notification.Type.ES_NODE_DISK_WATERMARK_LOW;
        }
        return null;
    }

    private void fixAllDiskUsageNotifications() {
        this.notificationService.fixed(Notification.Type.ES_NODE_DISK_WATERMARK_FLOOD_STAGE);
        this.notificationService.fixed(Notification.Type.ES_NODE_DISK_WATERMARK_HIGH);
        this.notificationService.fixed(Notification.Type.ES_NODE_DISK_WATERMARK_LOW);
    }

    private void publishDiskUsageNotifications(Map<Notification.Type, List<String>> notificationTypePerNodeIdentifier) {
        for (Map.Entry<Notification.Type, List<String>> entry : notificationTypePerNodeIdentifier.entrySet()) {
            if (this.notificationExists(entry.getKey())) continue;
            Notification notification = this.notificationService.buildNow().addType(entry.getKey()).addSeverity(Notification.Severity.URGENT).addDetail("nodes", String.join((CharSequence)", ", (Iterable<? extends CharSequence>)entry.getValue()));
            this.notificationService.publishIfFirst(notification);
            for (String node : entry.getValue()) {
                LOG.warn("Elasticsearch node [{}] triggered [{}] due to low free disk space", (Object)node, (Object)entry.getKey());
            }
        }
    }

    private boolean notificationExists(Notification.Type type) {
        return !this.notificationService.isFirst(type);
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean masterOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 30;
    }
}

