/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.tools;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.ConfigurationException;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.inputs.extractors.RegexReplaceExtractor;
import org.graylog2.plugin.inputs.Extractor;
import org.graylog2.rest.models.tools.requests.RegexReplaceTestRequest;
import org.graylog2.rest.models.tools.responses.RegexReplaceTesterResponse;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Path(value="/tools/regex_replace_tester")
public class RegexReplaceTesterResource
extends RestResource {
    @GET
    @Timed
    @Produces(value={"application/json"})
    public RegexReplaceTesterResponse regexTester(@QueryParam(value="regex") @NotEmpty String regex, @QueryParam(value="replacement") @NotNull String replacement, @QueryParam(value="replace_all") @DefaultValue(value="false") boolean replaceAll, @QueryParam(value="string") @NotNull String string) {
        return this.testRegexReplaceExtractor(string, regex, replacement, replaceAll);
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NoAuditEvent(value="only used to test regex replace extractor")
    public RegexReplaceTesterResponse testRegex(@Valid @NotNull RegexReplaceTestRequest r) {
        return this.testRegexReplaceExtractor(r.string(), r.regex(), r.replacement(), r.replaceAll());
    }

    private RegexReplaceTesterResponse testRegexReplaceExtractor(String example, String regex, String replacement, boolean replaceAll) {
        RegexReplaceExtractor extractor;
        ImmutableMap config = ImmutableMap.of((Object)"regex", (Object)regex, (Object)"replacement", (Object)replacement, (Object)"replace_all", (Object)replaceAll);
        try {
            extractor = new RegexReplaceExtractor(new MetricRegistry(), "test", "Test", 0L, Extractor.CursorStrategy.COPY, "test", "test", (Map<String, Object>)config, this.getCurrentUser().getName(), Collections.emptyList(), Extractor.ConditionType.NONE, "");
        }
        catch (Extractor.ReservedFieldException e) {
            throw new BadRequestException("Trying to overwrite a reserved message field", (Throwable)e);
        }
        catch (ConfigurationException e) {
            throw new BadRequestException("Invalid extractor configuration", (Throwable)e);
        }
        Extractor.Result result = extractor.runExtractor(example);
        RegexReplaceTesterResponse.Match match = result == null ? null : RegexReplaceTesterResponse.Match.create(String.valueOf(result.getValue()), result.getBeginIndex(), result.getEndIndex());
        return RegexReplaceTesterResponse.create(result != null, match, regex, replacement, replaceAll, example);
    }
}

