/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import com.google.common.collect.ImmutableList;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.realm.Realm;
import org.graylog2.security.OrderedAuthenticatingRealms;
import org.graylog2.security.realm.RootAccountRealm;

@Singleton
public class StaticOrderedAuthenticatingRealms
extends AbstractCollection<Realm>
implements OrderedAuthenticatingRealms {
    private static final ImmutableList<String> REALM_ORDER = ImmutableList.of((Object)"mongodb-session", (Object)"access-token", (Object)"http-header-authentication", (Object)"auth-service", (Object)"root-user");
    private final List<Realm> orderedRealms = REALM_ORDER.stream().map(realms::get).filter(Objects::nonNull).collect(Collectors.toList());

    @Inject
    public StaticOrderedAuthenticatingRealms(Map<String, AuthenticatingRealm> realms) {
        if (this.orderedRealms.size() < 1) {
            throw new IllegalStateException("No realms available, this must not happen!");
        }
    }

    @Override
    @Nonnull
    public Iterator<Realm> iterator() {
        return this.orderedRealms.iterator();
    }

    @Override
    public int size() {
        return this.orderedRealms.size();
    }

    @Override
    public Optional<Realm> getRootAccountRealm() {
        return this.orderedRealms.stream().filter(r -> r instanceof RootAccountRealm).findFirst();
    }
}

