/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.buffers;

import com.lmax.disruptor.WorkHandler;
import javax.inject.Inject;
import org.graylog2.plugin.journal.RawMessage;
import org.graylog2.shared.buffers.ProcessBuffer;
import org.graylog2.shared.buffers.RawMessageEvent;
import org.graylog2.system.processing.ProcessingStatusRecorder;

class DirectMessageHandler
implements WorkHandler<RawMessageEvent> {
    private final ProcessBuffer processBuffer;
    private final ProcessingStatusRecorder processingStatusRecorder;

    @Inject
    public DirectMessageHandler(ProcessBuffer processBuffer, ProcessingStatusRecorder processingStatusRecorder) {
        this.processBuffer = processBuffer;
        this.processingStatusRecorder = processingStatusRecorder;
    }

    public void onEvent(RawMessageEvent event) throws Exception {
        RawMessage rawMessage = event.getRawMessage();
        this.processBuffer.insertBlocking(rawMessage);
        if (rawMessage != null) {
            this.processingStatusRecorder.updateIngestReceiveTime(rawMessage.getTimestamp());
        }
        event.setRawMessage(null);
    }
}

