/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest;

import com.google.common.base.Strings;
import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import org.graylog.util.uuid.ConcurrentUUID;

@Priority(value=1980)
public class RequestIdFilter
implements ContainerRequestFilter {
    public static final String X_REQUEST_ID = "X-Request-Id";

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String id = requestContext.getHeaderString(X_REQUEST_ID);
        if (Strings.isNullOrEmpty((String)id)) {
            id = ConcurrentUUID.generateRandomUuid().toString();
        }
        requestContext.getHeaders().putSingle((Object)X_REQUEST_ID, (Object)id);
    }
}

