/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.graylog2.shared.security.tls.PemReader;

public final class PemKeyStore {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];

    protected static PKCS8EncodedKeySpec generateKeySpec(char[] password, byte[] key) throws IOException, PKCSException, OperatorCreationException {
        if (password == null || password.length == 0) {
            return new PKCS8EncodedKeySpec(key);
        }
        PKCS8EncryptedPrivateKeyInfo privateKeyInfo = new PKCS8EncryptedPrivateKeyInfo(key);
        InputDecryptorProvider decProv = new JceOpenSSLPKCS8DecryptorProviderBuilder().setProvider("BC").build(password);
        PrivateKeyInfo pkInfo = privateKeyInfo.decryptPrivateKeyInfo(decProv);
        PrivateKey privKey = new JcaPEMKeyConverter().setProvider("BC").getPrivateKey(pkInfo);
        return new PKCS8EncodedKeySpec(privKey.getEncoded());
    }

    public static KeyStore buildKeyStore(Path certChainFile, Path keyFile, char[] keyPasswordChars) throws GeneralSecurityException {
        try {
            return PemKeyStore.doBuildKeyStore(certChainFile, keyFile, keyPasswordChars);
        }
        catch (IOException | KeyException | KeyStoreException | NoSuchAlgorithmException | CertificateException | InvalidKeySpecException | OperatorCreationException | PKCSException e) {
            throw new GeneralSecurityException(e);
        }
    }

    private static KeyStore doBuildKeyStore(Path certChainFile, Path keyFile, char[] keyPasswordChars) throws KeyStoreException, NoSuchAlgorithmException, InvalidKeySpecException, CertificateException, KeyException, IOException, PKCSException, OperatorCreationException {
        PrivateKey key;
        char[] password = keyPasswordChars == null ? EMPTY_CHAR_ARRAY : keyPasswordChars;
        byte[] encodedKey = PemReader.readPrivateKey(keyFile);
        PKCS8EncodedKeySpec encodedKeySpec = PemKeyStore.generateKeySpec(keyPasswordChars, encodedKey);
        try {
            key = KeyFactory.getInstance("RSA").generatePrivate(encodedKeySpec);
        }
        catch (InvalidKeySpecException ignore) {
            try {
                key = KeyFactory.getInstance("DSA").generatePrivate(encodedKeySpec);
            }
            catch (InvalidKeySpecException ignore2) {
                try {
                    key = KeyFactory.getInstance("EC").generatePrivate(encodedKeySpec);
                }
                catch (InvalidKeySpecException e) {
                    throw new InvalidKeySpecException("Neither RSA, DSA nor EC worked", e);
                }
            }
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        List<byte[]> certs = PemReader.readCertificates(certChainFile);
        ArrayList<Certificate> certChain = new ArrayList<Certificate>(certs.size());
        for (byte[] buf : certs) {
            certChain.add(cf.generateCertificate(new ByteArrayInputStream(buf)));
        }
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null, password);
        ks.setKeyEntry("key", key, password, certChain.toArray(new Certificate[certChain.size()]));
        return ks;
    }
}

