/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.utilities;

import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;

public class ExceptionUtils {
    public static Throwable getRootCause(Throwable t) {
        return ExceptionUtils.getRootCause(t, false);
    }

    public static Throwable getRootCause(Throwable t, boolean causeNeedsMessage) {
        if (t == null) {
            return null;
        }
        Throwable rootCause = t;
        for (Throwable cause = rootCause.getCause(); cause != null && (!causeNeedsMessage || StringUtils.isNotBlank((CharSequence)cause.getMessage())) && cause != rootCause; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause;
    }

    public static String formatMessageCause(Throwable t) {
        if (t == null) {
            return "Unknown cause";
        }
        StringBuilder causeMessage = new StringBuilder();
        String message = t.getMessage();
        if (t.getClass() == UnknownHostException.class) {
            causeMessage.append("Unknown host '");
            causeMessage.append(message);
            causeMessage.append("'");
        } else {
            causeMessage.append(message);
        }
        if (message != null && !message.endsWith(".") && !message.endsWith("!")) {
            causeMessage.append(".");
        }
        return causeMessage.toString();
    }

    public static String getRootCauseMessage(Throwable t) {
        return ExceptionUtils.formatMessageCause(ExceptionUtils.getRootCause(t));
    }

    public static String getRootCauseOrMessage(Throwable t) {
        Throwable rootCause = ExceptionUtils.getRootCause(t, true);
        return ExceptionUtils.formatMessageCause(rootCause != null ? rootCause : t);
    }
}

