/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.storage.providers;

import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.graylog2.plugin.Version;
import org.graylog2.storage.providers.AtomicCache;
import org.graylog2.storage.versionprobe.ElasticsearchProbeException;
import org.graylog2.storage.versionprobe.VersionProbe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ElasticsearchVersionProvider
implements Provider<Version> {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchVersionProvider.class);
    public static final String NO_HOST_REACHABLE_ERROR = "Unable to probe any host for Elasticsearch version";
    private final Optional<Version> versionOverride;
    private final List<URI> elasticsearchHosts;
    private final VersionProbe versionProbe;
    private final AtomicCache<Optional<Version>> cachedVersion;

    @Inject
    public ElasticsearchVersionProvider(@Named(value="elasticsearch_version") @Nullable Version versionOverride, @Named(value="elasticsearch_hosts") List<URI> elasticsearchHosts, VersionProbe versionProbe, AtomicCache<Optional<Version>> cachedVersion) {
        this.versionOverride = Optional.ofNullable(versionOverride);
        this.elasticsearchHosts = elasticsearchHosts;
        this.versionProbe = versionProbe;
        this.cachedVersion = cachedVersion;
    }

    public Version get() {
        if (this.versionOverride.isPresent()) {
            Version explicitVersion = this.versionOverride.get();
            LOG.info("Elasticsearch version set to " + explicitVersion + " - disabling version probe.");
            return explicitVersion;
        }
        try {
            return (Version)this.cachedVersion.get(() -> {
                Optional<Version> probedVersion = this.versionProbe.probe(this.elasticsearchHosts);
                probedVersion.ifPresent(version -> LOG.info("Elasticsearch cluster is running v" + version));
                return probedVersion;
            }).orElseThrow(() -> new ElasticsearchProbeException("Unable to probe any host for Elasticsearch version!"));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ElasticsearchProbeException("Unable to probe any host for Elasticsearch version: ", e);
        }
    }
}

