/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications.types;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import javax.inject.Inject;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.graylog.events.notifications.EventNotification;
import org.graylog.events.notifications.EventNotificationContext;
import org.graylog.events.notifications.EventNotificationModelData;
import org.graylog.events.notifications.EventNotificationService;
import org.graylog.events.notifications.PermanentEventNotificationException;
import org.graylog.events.notifications.TemporaryEventNotificationException;
import org.graylog.events.notifications.types.HTTPEventNotificationConfig;
import org.graylog2.plugin.MessageSummary;
import org.graylog2.system.urlwhitelist.UrlWhitelistNotificationService;
import org.graylog2.system.urlwhitelist.UrlWhitelistService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPEventNotification
implements EventNotification {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPEventNotification.class);
    private static final MediaType CONTENT_TYPE = MediaType.parse((String)"application/json");
    private final EventNotificationService notificationCallbackService;
    private final ObjectMapper objectMapper;
    private final OkHttpClient httpClient;
    private final UrlWhitelistService whitelistService;
    private final UrlWhitelistNotificationService urlWhitelistNotificationService;

    @Inject
    public HTTPEventNotification(EventNotificationService notificationCallbackService, ObjectMapper objectMapper, OkHttpClient httpClient, UrlWhitelistService whitelistService, UrlWhitelistNotificationService urlWhitelistNotificationService) {
        this.notificationCallbackService = notificationCallbackService;
        this.objectMapper = objectMapper;
        this.httpClient = httpClient;
        this.whitelistService = whitelistService;
        this.urlWhitelistNotificationService = urlWhitelistNotificationService;
    }

    @Override
    public void execute(EventNotificationContext ctx) throws TemporaryEventNotificationException, PermanentEventNotificationException {
        byte[] body;
        HTTPEventNotificationConfig config = (HTTPEventNotificationConfig)ctx.notificationConfig();
        HttpUrl httpUrl = HttpUrl.parse((String)config.url());
        if (httpUrl == null) {
            throw new TemporaryEventNotificationException("Malformed URL: <" + config.url() + "> in notification <" + ctx.notificationId() + ">");
        }
        ImmutableList<MessageSummary> backlog = this.notificationCallbackService.getBacklogForEvent(ctx);
        EventNotificationModelData model = EventNotificationModelData.of(ctx, backlog);
        if (!this.whitelistService.isWhitelisted(config.url())) {
            if (!"NotificationTestId".equals(ctx.notificationId())) {
                this.publishSystemNotificationForWhitelistFailure(config.url(), model.eventDefinitionTitle());
            }
            throw new TemporaryEventNotificationException("URL <" + config.url() + "> is not whitelisted.");
        }
        try {
            body = this.objectMapper.writeValueAsBytes((Object)model);
        }
        catch (JsonProcessingException e) {
            throw new PermanentEventNotificationException("Unable to serialize notification", e);
        }
        Request request = new Request.Builder().url(httpUrl).post(RequestBody.create((MediaType)CONTENT_TYPE, (byte[])body)).build();
        LOG.debug("Requesting HTTP endpoint at <{}> in notification <{}>", (Object)config.url(), (Object)ctx.notificationId());
        try (Response r = this.httpClient.newCall(request).execute();){
            if (!r.isSuccessful()) {
                throw new PermanentEventNotificationException("Expected successful HTTP response [2xx] but got [" + r.code() + "]. " + config.url());
            }
        }
        catch (IOException e) {
            throw new PermanentEventNotificationException(e.getMessage());
        }
    }

    private void publishSystemNotificationForWhitelistFailure(String url, String eventNotificationTitle) {
        String description = "The alert notification \"" + eventNotificationTitle + "\" is trying to access a URL which is not whitelisted. Please check your configuration. [url: \"" + url + "\"]";
        this.urlWhitelistNotificationService.publishWhitelistFailure(description);
    }

    public static interface Factory
    extends EventNotification.Factory {
        public HTTPEventNotification create();
    }
}

