/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor.aggregation;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog.events.processor.aggregation.AggregationFunction;
import org.graylog.events.processor.aggregation.AggregationSeries;

final class AutoValue_AggregationSeries
extends AggregationSeries {
    private final String id;
    private final AggregationFunction function;
    private final Optional<String> field;

    private AutoValue_AggregationSeries(String id, AggregationFunction function, Optional<String> field) {
        this.id = id;
        this.function = function;
        this.field = field;
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="function")
    public AggregationFunction function() {
        return this.function;
    }

    @Override
    @JsonProperty(value="field")
    public Optional<String> field() {
        return this.field;
    }

    public String toString() {
        return "AggregationSeries{id=" + this.id + ", function=" + (Object)((Object)this.function) + ", field=" + this.field + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AggregationSeries) {
            AggregationSeries that = (AggregationSeries)o;
            return this.id.equals(that.id()) && this.function.equals((Object)that.function()) && this.field.equals(that.field());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.id.hashCode();
        h$ *= 1000003;
        h$ ^= this.function.hashCode();
        h$ *= 1000003;
        return h$ ^= this.field.hashCode();
    }

    @Override
    public AggregationSeries.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends AggregationSeries.Builder {
        private String id;
        private AggregationFunction function;
        private Optional<String> field = Optional.empty();

        Builder() {
        }

        private Builder(AggregationSeries source) {
            this.id = source.id();
            this.function = source.function();
            this.field = source.field();
        }

        @Override
        public AggregationSeries.Builder id(String id) {
            if (id == null) {
                throw new NullPointerException("Null id");
            }
            this.id = id;
            return this;
        }

        @Override
        public AggregationSeries.Builder function(AggregationFunction function) {
            if (function == null) {
                throw new NullPointerException("Null function");
            }
            this.function = function;
            return this;
        }

        @Override
        public AggregationSeries.Builder field(@Nullable String field) {
            this.field = Optional.ofNullable(field);
            return this;
        }

        @Override
        Optional<String> field() {
            return this.field;
        }

        @Override
        AggregationSeries autoBuild() {
            String missing = "";
            if (this.id == null) {
                missing = missing + " id";
            }
            if (this.function == null) {
                missing = missing + " function";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AggregationSeries(this.id, this.function, this.field);
        }
    }
}

