/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views;

import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import org.graylog.plugins.views.Requirement;
import org.graylog.plugins.views.search.QueryMetadataDecorator;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.engine.GeneratedQueryContext;
import org.graylog.plugins.views.search.engine.QueryBackend;
import org.graylog.plugins.views.search.engine.QueryStringDecorator;
import org.graylog.plugins.views.search.export.ExportBackend;
import org.graylog.plugins.views.search.rest.SeriesDescription;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog2.plugin.PluginMetaData;
import org.graylog2.plugin.Version;
import org.graylog2.plugin.VersionAwareModule;

public abstract class ViewsModule
extends VersionAwareModule {
    protected LinkedBindingBuilder<ExportBackend> bindExportBackend(Version supportedVersion) {
        return this.bindForVersion(supportedVersion, ExportBackend.class);
    }

    protected void registerQueryMetadataDecorator(Class<? extends QueryMetadataDecorator> queryMetadataDecorator) {
        this.queryMetadataDecoratorBinder().addBinding().to(queryMetadataDecorator);
    }

    protected Multibinder<QueryMetadataDecorator> queryMetadataDecoratorBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), QueryMetadataDecorator.class);
    }

    protected void registerProvidedViewsCapability(String capability, PluginMetaData plugin) {
        this.viewsCapabilityBinder().addBinding((Object)capability).toInstance((Object)plugin);
    }

    protected MapBinder<String, PluginMetaData> viewsCapabilityBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), String.class, PluginMetaData.class);
    }

    protected void registerViewRequirement(Class<? extends Requirement<ViewDTO>> viewRequirement) {
        this.viewRequirementBinder().addBinding().to(viewRequirement);
    }

    protected Multibinder<Requirement<ViewDTO>> viewRequirementBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<Requirement<ViewDTO>>(){});
    }

    protected void registerSearchRequirement(Class<? extends Requirement<Search>> searchRequirement) {
        this.searchRequirementBinder().addBinding().to(searchRequirement);
    }

    protected Multibinder<Requirement<Search>> searchRequirementBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<Requirement<Search>>(){});
    }

    protected MapBinder<String, SeriesDescription> seriesSpecBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), String.class, SeriesDescription.class);
    }

    protected void registerPivotAggregationFunction(String name, Class<? extends SeriesSpec> seriesSpecClass) {
        this.registerJacksonSubtype(seriesSpecClass);
        this.seriesSpecBinder().addBinding((Object)name).toInstance((Object)SeriesDescription.create(name));
    }

    protected MapBinder<String, QueryBackend<? extends GeneratedQueryContext>> queryBackendBinder(Version version) {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<QueryBackend<? extends GeneratedQueryContext>>(){});
    }

    protected ScopedBindingBuilder registerQueryBackend(Version version, String name, Class<? extends QueryBackend<? extends GeneratedQueryContext>> implementation) {
        return this.queryBackendBinder(version).addBinding((Object)name).to(implementation);
    }

    protected void registerESQueryDecorator(Class<? extends QueryStringDecorator> esQueryDecorator) {
        this.esQueryDecoratorBinder().addBinding().to(esQueryDecorator);
    }

    protected Multibinder<QueryStringDecorator> esQueryDecoratorBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), QueryStringDecorator.class);
    }
}

