/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin;

import com.google.common.util.concurrent.Service;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.ext.ExceptionMapper;
import org.graylog.events.fields.providers.FieldValueProvider;
import org.graylog.events.notifications.EventNotification;
import org.graylog.events.notifications.EventNotificationConfig;
import org.graylog.events.processor.EventProcessor;
import org.graylog.events.processor.EventProcessorConfig;
import org.graylog.events.processor.EventProcessorParameters;
import org.graylog.events.processor.storage.EventStorageHandler;
import org.graylog.grn.GRNDescriptorProvider;
import org.graylog.grn.GRNType;
import org.graylog.scheduler.Job;
import org.graylog.scheduler.JobDefinitionConfig;
import org.graylog.scheduler.JobSchedule;
import org.graylog.scheduler.JobTriggerData;
import org.graylog2.audit.AuditEventType;
import org.graylog2.audit.PluginAuditEventTypes;
import org.graylog2.audit.formatter.AuditEventFormatter;
import org.graylog2.contentpacks.constraints.ConstraintChecker;
import org.graylog2.contentpacks.facades.EntityFacade;
import org.graylog2.contentpacks.model.ModelType;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.PluginConfigBean;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.alarms.callbacks.AlarmCallback;
import org.graylog2.plugin.filters.MessageFilter;
import org.graylog2.plugin.indexer.retention.RetentionStrategy;
import org.graylog2.plugin.indexer.rotation.RotationStrategy;
import org.graylog2.plugin.inject.Graylog2Module;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.inputs.transports.Transport;
import org.graylog2.plugin.messageprocessors.MessageProcessor;
import org.graylog2.plugin.outputs.MessageOutput;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.plugin.security.PasswordAlgorithm;
import org.graylog2.plugin.security.PluginPermissions;

public abstract class PluginModule
extends Graylog2Module {
    public Set<? extends PluginConfigBean> getConfigBeans() {
        return Collections.emptySet();
    }

    protected void addMessageInput(Class<? extends MessageInput> messageInputClass) {
        this.installInput(this.inputsMapBinder(), messageInputClass);
    }

    protected <T extends MessageInput> void addMessageInput(Class<T> messageInputClass, Class<? extends MessageInput.Factory<T>> factoryClass) {
        this.installInput(this.inputsMapBinder(), messageInputClass, factoryClass);
    }

    protected void addMessageFilter(Class<? extends MessageFilter> messageFilterClass) {
        Multibinder messageInputs = Multibinder.newSetBinder((Binder)this.binder(), MessageFilter.class);
        messageInputs.addBinding().to(messageFilterClass);
    }

    protected void addPeriodical(Class<? extends Periodical> periodicalClass) {
        Multibinder periodicalBinder = Multibinder.newSetBinder((Binder)this.binder(), Periodical.class);
        periodicalBinder.addBinding().to(periodicalClass);
    }

    protected void addRotationStrategy(Class<? extends RotationStrategy> rotationStrategyClass) {
        this.installRotationStrategy(this.rotationStrategiesMapBinder(), rotationStrategyClass);
    }

    protected void addRetentionStrategy(Class<? extends RetentionStrategy> retentionStrategyClass) {
        this.installRetentionStrategy(this.retentionStrategyMapBinder(), retentionStrategyClass);
    }

    protected void addAlarmCallback(Class<? extends AlarmCallback> alarmCallbackClass) {
        Multibinder alarmCallbackInstanceBinder = Multibinder.newSetBinder((Binder)this.binder(), AlarmCallback.class);
        alarmCallbackInstanceBinder.addBinding().to(alarmCallbackClass);
        TypeLiteral<Class<? extends AlarmCallback>> type = new TypeLiteral<Class<? extends AlarmCallback>>(){};
        Multibinder alarmCallbackBinder = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)type);
        alarmCallbackBinder.addBinding().toInstance(alarmCallbackClass);
    }

    protected void addInitializer(Class<? extends Service> initializerClass) {
        Multibinder<Service> serviceBinder = this.serviceBinder();
        serviceBinder.addBinding().to(initializerClass);
    }

    protected void addMessageOutput(Class<? extends MessageOutput> messageOutputClass) {
        this.installOutput(this.outputsMapBinder(), messageOutputClass);
    }

    protected <T extends MessageOutput> void addMessageOutput(Class<T> messageOutputClass, Class<? extends MessageOutput.Factory<T>> factory) {
        this.installOutput(this.outputsMapBinder(), messageOutputClass, factory);
    }

    protected <T extends MessageOutput> void addMessageOutput2(Class<T> messageOutputClass, Class<? extends MessageOutput.Factory2<T>> factory) {
        this.installOutput2(this.outputsMapBinder2(), messageOutputClass, factory);
    }

    protected void addRestResource(Class<? extends PluginRestResource> restResourceClass) {
        MapBinder pluginRestResourceMapBinder = MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<String>(){}, (TypeLiteral)new TypeLiteral<Class<? extends PluginRestResource>>(){}).permitDuplicates();
        pluginRestResourceMapBinder.addBinding((Object)((Object)((Object)this)).getClass().getPackage().getName()).toInstance(restResourceClass);
    }

    protected void addJerseyExceptionMapper(Class<? extends ExceptionMapper> exceptionMapperClass) {
        this.jerseyExceptionMapperBinder().addBinding().toInstance(exceptionMapperClass);
    }

    protected void addConfigBeans() {
        Multibinder pluginConfigBeans = Multibinder.newSetBinder((Binder)this.binder(), PluginConfigBean.class);
        for (PluginConfigBean pluginConfigBean : this.getConfigBeans()) {
            pluginConfigBeans.addBinding().toInstance((Object)pluginConfigBean);
        }
    }

    protected void addTransport(String name, Class<? extends Transport> transportClass) {
        this.installTransport(this.transportMapBinder(), name, transportClass);
    }

    protected void addTransport(String name, Class<? extends Transport> transportClass, Class<? extends Transport.Config> configClass, Class<? extends Transport.Factory<? extends Transport>> factoryClass) {
        this.installTransport(this.transportMapBinder(), name, transportClass, configClass, factoryClass);
    }

    protected void addCodec(String name, Class<? extends Codec> codecClass) {
        this.installCodec(this.codecMapBinder(), name, codecClass);
    }

    protected void addCodec(String name, Class<? extends Codec> codecClass, Class<? extends Codec.Config> configClass, Class<? extends Codec.Factory<? extends Codec>> factoryClass) {
        this.installCodec(this.codecMapBinder(), name, codecClass, configClass, factoryClass);
    }

    protected void addPasswordAlgorithm(String passwordAlgorithmName, Class<? extends PasswordAlgorithm> passwordAlgorithmClass) {
        this.passwordAlgorithmBinder().addBinding((Object)passwordAlgorithmName).to(passwordAlgorithmClass);
    }

    protected Multibinder<MessageProcessor> processorBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), MessageProcessor.class);
    }

    protected Multibinder<MessageProcessor.Descriptor> processorDescriptorBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), MessageProcessor.Descriptor.class);
    }

    protected void addMessageProcessor(Class<? extends MessageProcessor> processorClass, Class<? extends MessageProcessor.Descriptor> descriptorClass) {
        this.processorBinder().addBinding().to(processorClass);
        this.processorDescriptorBinder().addBinding().to(descriptorClass);
    }

    protected void addPermissions(Class<? extends PluginPermissions> permissionsClass) {
        this.installPermissions(this.permissionsBinder(), permissionsClass);
    }

    protected void addAuditEventTypes(Class<? extends PluginAuditEventTypes> auditEventTypesClass) {
        this.installAuditEventTypes(this.auditEventTypesBinder(), auditEventTypesClass);
    }

    protected void addAuditEventFormatter(AuditEventType auditEventType, Class<? extends AuditEventFormatter> auditEventFormatterClass) {
        this.installAuditEventFormatter(this.auditEventFormatterMapBinder(), auditEventType, auditEventFormatterClass);
    }

    protected void addAlertCondition(String name, Class<? extends AlertCondition> alertConditionClass, Class<? extends AlertCondition.Factory> alertConditionFactoryClass) {
        this.installAlertConditionWithCustomName(this.alertConditionBinder(), name, alertConditionClass, alertConditionFactoryClass);
    }

    protected void addMigration(Class<? extends Migration> migrationClass) {
        this.migrationsBinder().addBinding().to(migrationClass);
    }

    protected void addEntityFacade(ModelType entityType, Class<? extends EntityFacade<?>> entityFacadeClass) {
        this.entityFacadeBinder().addBinding((Object)entityType).to(entityFacadeClass);
    }

    protected void addConstraintChecker(Class<? extends ConstraintChecker> constraintCheckerClass) {
        this.constraintCheckerBinder().addBinding().to(constraintCheckerClass);
    }

    private MapBinder<String, EventProcessor.Factory> eventProcessorBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), String.class, EventProcessor.Factory.class);
    }

    protected void addEventProcessor(String name, Class<? extends EventProcessor> processorClass, Class<? extends EventProcessor.Factory> factoryClass, Class<? extends EventProcessorConfig> configClass, Class<? extends EventProcessorParameters> parametersClass) {
        this.install(new FactoryModuleBuilder().implement(EventProcessor.class, processorClass).build(factoryClass));
        this.eventProcessorBinder().addBinding((Object)name).to(factoryClass);
        this.registerJacksonSubtype(configClass, name);
        this.registerJacksonSubtype(parametersClass, name);
    }

    private MapBinder<String, EventStorageHandler.Factory> eventStorageHandlerBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), String.class, EventStorageHandler.Factory.class);
    }

    protected void addEventStorageHandler(String name, Class<? extends EventStorageHandler> handlerClass, Class<? extends EventStorageHandler.Factory> factoryClass, Class<? extends EventStorageHandler.Config> configClass) {
        this.install(new FactoryModuleBuilder().implement(EventStorageHandler.class, handlerClass).build(factoryClass));
        this.eventStorageHandlerBinder().addBinding((Object)name).to(factoryClass);
        this.registerJacksonSubtype(configClass, name);
    }

    private MapBinder<String, FieldValueProvider.Factory> eventFieldValueProviderBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), String.class, FieldValueProvider.Factory.class);
    }

    protected void addEventFieldValueProvider(String name, Class<? extends FieldValueProvider> fieldValueProviderClass, Class<? extends FieldValueProvider.Factory> factoryClass, Class<? extends FieldValueProvider.Config> configClass) {
        this.install(new FactoryModuleBuilder().implement(FieldValueProvider.class, fieldValueProviderClass).build(factoryClass));
        this.eventFieldValueProviderBinder().addBinding((Object)name).to(factoryClass);
        this.registerJacksonSubtype(configClass, name);
    }

    private MapBinder<String, Job.Factory> jobBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), String.class, Job.Factory.class);
    }

    protected void addSchedulerJob(String name, Class<? extends Job> jobClass, Class<? extends Job.Factory> factoryClass, Class<? extends JobDefinitionConfig> configClass) {
        this.addSchedulerJob(name, jobClass, factoryClass, configClass, null);
    }

    protected void addSchedulerJob(String name, Class<? extends Job> jobClass, Class<? extends Job.Factory> factoryClass, Class<? extends JobDefinitionConfig> configClass, Class<? extends JobTriggerData> dataClass) {
        this.install(new FactoryModuleBuilder().implement(Job.class, jobClass).build(factoryClass));
        this.jobBinder().addBinding((Object)name).to(factoryClass);
        this.registerJacksonSubtype(configClass, name);
        if (dataClass != null) {
            this.registerJacksonSubtype(dataClass, name);
        }
    }

    protected void addJobSchedulerSchedule(String name, Class<? extends JobSchedule> scheduleClass) {
        this.registerJacksonSubtype(scheduleClass, name);
    }

    private MapBinder<String, EventNotification.Factory> eventNotificationBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), String.class, EventNotification.Factory.class);
    }

    protected void addNotificationType(String name, Class<? extends EventNotificationConfig> notificationClass, Class<? extends EventNotification> handlerClass, Class<? extends EventNotification.Factory> factoryClass) {
        this.install(new FactoryModuleBuilder().implement(EventNotification.class, handlerClass).build(factoryClass));
        this.eventNotificationBinder().addBinding((Object)name).to(factoryClass);
        this.registerJacksonSubtype(notificationClass, name);
    }

    protected void addGRNType(GRNType type, Class<? extends GRNDescriptorProvider> descriptorProvider) {
        MapBinder mapBinder = MapBinder.newMapBinder((Binder)this.binder(), GRNType.class, GRNDescriptorProvider.class);
        mapBinder.addBinding((Object)type).to(descriptorProvider);
    }
}

