/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.DefaultSessionKey;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SessionManager;
import org.graylog2.plugin.database.users.User;
import org.graylog2.security.MongoDBSessionService;
import org.graylog2.security.MongoDbSession;
import org.graylog2.shared.users.UserService;
import org.graylog2.users.events.UserChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSessionTerminationListener {
    private static final Logger LOG = LoggerFactory.getLogger(UserSessionTerminationListener.class);
    private static final EnumSet<User.AccountStatus> SESSION_TERMINATION_STATUS = EnumSet.of(User.AccountStatus.DELETED, User.AccountStatus.DISABLED);
    private final MongoDBSessionService sessionService;
    private final DefaultSecurityManager securityManager;
    private final UserService userService;

    @Inject
    public UserSessionTerminationListener(MongoDBSessionService sessionService, DefaultSecurityManager securityManager, UserService userService, EventBus eventBus) {
        this.sessionService = sessionService;
        this.securityManager = securityManager;
        this.userService = userService;
        eventBus.register((Object)this);
    }

    @Subscribe
    public void handleUserChanged(UserChangedEvent event) {
        User user = this.userService.loadById(event.userId());
        if (user != null && SESSION_TERMINATION_STATUS.contains((Object)user.getAccountStatus())) {
            this.terminateSessionsFor(user);
        }
    }

    private void terminateSessionsFor(User user) {
        try {
            Set<String> sessionIds = this.getSessionIDsForUser(user);
            SessionManager sessionManager = this.securityManager.getSessionManager();
            for (String sessionId : sessionIds) {
                Session session = sessionManager.getSession((SessionKey)new DefaultSessionKey((Serializable)((Object)sessionId)));
                if (session == null) continue;
                LOG.info("Stopping session <{}> for user <{}/{}>", new Object[]{sessionId, user.getName(), user.getId()});
                session.stop();
            }
        }
        catch (Exception e) {
            LOG.error("Couldn't stop session for user <{}/{}>", new Object[]{user.getName(), user.getId(), e});
        }
    }

    private Set<String> getSessionIDsForUser(User user) {
        String userId = Objects.requireNonNull(user.getId(), "user ID cannot be null");
        return this.sessionService.loadAll().stream().filter(session -> userId.equals(session.getUserIdAttribute().orElse(null))).map(MongoDbSession::getSessionId).collect(Collectors.toSet());
    }
}

