/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.storage.versionprobe;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Inject;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.graylog2.plugin.Version;
import org.graylog2.storage.versionprobe.ElasticsearchProbeException;
import org.graylog2.storage.versionprobe.RootResponse;
import org.graylog2.storage.versionprobe.RootRoute;
import org.graylog2.storage.versionprobe.VersionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class VersionProbe {
    private static final Logger LOG = LoggerFactory.getLogger(VersionProbe.class);
    private final ObjectMapper objectMapper;
    private final OkHttpClient okHttpClient;

    @Inject
    public VersionProbe(ObjectMapper objectMapper, OkHttpClient okHttpClient) {
        this.objectMapper = objectMapper;
        this.okHttpClient = okHttpClient;
    }

    public Optional<Version> probe(Collection<URI> hosts) {
        return hosts.stream().map(this::probe).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    public Optional<Version> probe(URI host) {
        Retrofit retrofit;
        try {
            retrofit = new Retrofit.Builder().baseUrl(host.toURL()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)this.objectMapper)).client(this.addAuthenticationIfPresent(host, this.okHttpClient)).build();
        }
        catch (MalformedURLException e) {
            LOG.error("Elasticsearch node URL is invalid: " + host.toString(), (Throwable)e);
            return Optional.empty();
        }
        RootRoute root = (RootRoute)retrofit.create(RootRoute.class);
        return this.rootResponse(root).map(RootResponse::version).map(VersionResponse::number).flatMap(this::parseVersion);
    }

    private OkHttpClient addAuthenticationIfPresent(URI host, OkHttpClient okHttpClient) {
        if (Strings.emptyToNull((String)host.getUserInfo()) != null) {
            String[] credentials = host.getUserInfo().split(":");
            String username = credentials[0];
            String password = credentials[1];
            String authToken = Credentials.basic((String)username, (String)password);
            return okHttpClient.newBuilder().addInterceptor(chain -> {
                Request originalRequest = chain.request();
                Request.Builder builder = originalRequest.newBuilder().header("Authorization", authToken);
                Request newRequest = builder.build();
                return chain.proceed(newRequest);
            }).build();
        }
        return okHttpClient;
    }

    private Optional<Version> parseVersion(String versionString) {
        String[] versionParts = versionString.split("\\.");
        if (versionParts.length != 3) {
            LOG.error("Unable to parse version retrieved from Elasticsearch node: " + versionString);
            return Optional.empty();
        }
        try {
            int major = Integer.parseUnsignedInt(versionParts[0]);
            int minor = Integer.parseUnsignedInt(versionParts[1]);
            int patch = Integer.parseUnsignedInt(versionParts[2]);
            Version version = Version.from(major, minor, patch);
            return Optional.of(version);
        }
        catch (NumberFormatException e) {
            throw new ElasticsearchProbeException("Unable to parse version retrieved from Elasticsearch node: " + versionString, e);
        }
    }

    private Optional<RootResponse> rootResponse(RootRoute rootRoute) {
        try {
            Response response = rootRoute.root().execute();
            if (response.isSuccessful()) {
                return Optional.ofNullable((RootResponse)response.body());
            }
        }
        catch (IOException e) {
            LOG.error("Unable to retrieve version from Elasticsearch node: ", (Throwable)e);
        }
        return Optional.empty();
    }
}

