/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.netflow.v9;

import com.google.auto.value.AutoValue;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog.plugins.netflow.v9.AutoValue_RawNetFlowV9Packet;
import org.graylog.plugins.netflow.v9.NetFlowV9Header;

@AutoValue
public abstract class RawNetFlowV9Packet {
    public abstract NetFlowV9Header header();

    public abstract int dataLength();

    public abstract Map<Integer, byte[]> templates();

    @Nullable
    public abstract Map.Entry<Integer, byte[]> optionTemplate();

    public abstract Set<Integer> usedTemplates();

    public static RawNetFlowV9Packet create(NetFlowV9Header header, int dataLength, Map<Integer, byte[]> templates, @Nullable Map.Entry<Integer, byte[]> optTemplate, Set<Integer> usedTemplates) {
        return new AutoValue_RawNetFlowV9Packet(header, dataLength, templates, optTemplate, usedTemplates);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\n");
        sb.append(this.header().prettyHexDump()).append("\n");
        sb.append("\nTemplates:\n");
        this.templates().forEach((integer, byteBuf) -> sb.append("\n").append(integer).append(":\n").append(ByteBufUtil.prettyHexDump((ByteBuf)Unpooled.wrappedBuffer((byte[])byteBuf))));
        Map.Entry<Integer, byte[]> optionTemplate = this.optionTemplate();
        if (optionTemplate != null) {
            sb.append("\nOption Template:\n").append(ByteBufUtil.prettyHexDump((ByteBuf)Unpooled.wrappedBuffer((byte[])optionTemplate.getValue())));
        }
        sb.append("\nData flows using these templates:\n");
        this.usedTemplates().forEach(templateId -> sb.append(templateId).append(" "));
        return sb.toString();
    }
}

