/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog.security.authservice.AutoValue_UserDetails;

@AutoValue
public abstract class UserDetails {
    public abstract Optional<String> databaseId();

    public abstract String authServiceType();

    public abstract String authServiceId();

    public abstract String base64AuthServiceUid();

    public abstract String username();

    public abstract boolean accountIsEnabled();

    public abstract String email();

    public abstract String fullName();

    public abstract Set<String> defaultRoles();

    public UserDetails withDatabaseId(String id) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"id cannot be null or empty");
        return this.toBuilder().databaseId(id).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public static Builder create() {
            return new AutoValue_UserDetails.Builder();
        }

        public abstract Builder databaseId(@Nullable String var1);

        public abstract Builder authServiceType(String var1);

        public abstract Builder authServiceId(String var1);

        public abstract Builder base64AuthServiceUid(String var1);

        public abstract Builder username(String var1);

        public abstract Builder accountIsEnabled(boolean var1);

        public abstract Builder email(String var1);

        public abstract Builder fullName(String var1);

        public abstract Builder defaultRoles(Set<String> var1);

        public abstract UserDetails build();
    }
}

