/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import javax.inject.Inject;
import org.graylog2.indexer.IndexFailureService;
import org.graylog2.indexer.messages.Messages;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.lifecycles.Lifecycle;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexFailuresPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(IndexFailuresPeriodical.class);
    private final IndexFailureService indexFailureService;
    private final Messages messages;
    private final ServerStatus serverStatus;
    private final MetricRegistry metricRegistry;

    @Inject
    public IndexFailuresPeriodical(IndexFailureService indexFailureService, Messages messages, ServerStatus serverStatus, MetricRegistry metricRegistry) {
        this.indexFailureService = indexFailureService;
        this.messages = messages;
        this.serverStatus = serverStatus;
        this.metricRegistry = metricRegistry;
    }

    @Override
    public void initialize() {
        this.metricRegistry.register(MetricRegistry.name(IndexFailuresPeriodical.class, (String[])new String[]{"queueSize"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return IndexFailuresPeriodical.this.messages.getIndexFailureQueue().size();
            }
        });
    }

    @Override
    public void doRun() {
        while (this.serverStatus.getLifecycle() != Lifecycle.HALTING) {
            try {
                this.messages.getIndexFailureQueue().take().forEach(this.indexFailureService::saveWithoutValidation);
            }
            catch (Exception e) {
                LOG.error("Could not persist index failure.", (Throwable)e);
            }
        }
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public boolean runsForever() {
        return true;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return false;
    }

    @Override
    public boolean masterOnly() {
        return false;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 0;
    }
}

