/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.github.joschi.jadconfig.util.Size;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.shaded.kafka09.log.LogSegment;
import org.graylog2.Configuration;
import org.graylog2.plugin.KafkaJournalConfiguration;
import org.graylog2.plugin.ThrottleState;
import org.graylog2.rest.resources.system.responses.JournalSummaryResponse;
import org.graylog2.rest.resources.system.responses.KafkaJournalConfigurationSummary;
import org.graylog2.shared.journal.Journal;
import org.graylog2.shared.journal.KafkaJournal;
import org.graylog2.shared.rest.resources.RestResource;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/Journal", description="Message journal information of this node.")
@Produces(value={"application/json"})
@Path(value="/system/journal")
public class JournalResource
extends RestResource {
    private static final Logger log = LoggerFactory.getLogger(JournalResource.class);
    private final boolean journalEnabled;
    private final Journal journal;
    private final KafkaJournalConfiguration kafkaJournalConfiguration;

    @Inject
    public JournalResource(Configuration configuration, KafkaJournalConfiguration kafkaJournalConfiguration, Journal journal) {
        this.kafkaJournalConfiguration = kafkaJournalConfiguration;
        this.journalEnabled = configuration.isMessageJournalEnabled();
        this.journal = journal;
    }

    @GET
    @Timed
    @ApiOperation(value="Get current state of the journal on this node.")
    @RequiresPermissions(value={"journal:read"})
    public JournalSummaryResponse show() {
        if (!this.journalEnabled) {
            return JournalSummaryResponse.createDisabled();
        }
        if (this.journal instanceof KafkaJournal) {
            KafkaJournal kafkaJournal = (KafkaJournal)this.journal;
            ThrottleState throttleState = kafkaJournal.getThrottleState();
            long oldestSegment = Long.MAX_VALUE;
            for (LogSegment segment : kafkaJournal.getSegments()) {
                oldestSegment = Math.min(oldestSegment, segment.created());
            }
            return JournalSummaryResponse.createEnabled(throttleState.appendEventsPerSec, throttleState.readEventsPerSec, throttleState.uncommittedJournalEntries, Size.bytes((long)throttleState.journalSize), Size.bytes((long)throttleState.journalSizeLimit), kafkaJournal.numberOfSegments(), new DateTime(oldestSegment, DateTimeZone.UTC), KafkaJournalConfigurationSummary.of(this.kafkaJournalConfiguration));
        }
        log.warn("Unknown Journal implementation {} in use, cannot get information about it. Pretending journal is disabled.", this.journal.getClass());
        return JournalSummaryResponse.createDisabled();
    }
}

