/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.realm;

import com.google.common.base.Joiner;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAccount;
import org.apache.shiro.authc.credential.AllowAllCredentialsMatcher;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.graylog.security.authservice.AuthServiceAuthenticator;
import org.graylog.security.authservice.AuthServiceCredentials;
import org.graylog.security.authservice.AuthServiceException;
import org.graylog.security.authservice.AuthServiceResult;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.security.headerauth.HTTPHeaderAuthConfig;
import org.graylog2.shared.security.HttpHeadersToken;
import org.graylog2.shared.security.ShiroSecurityContext;
import org.graylog2.utilities.IpSubnet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPHeaderAuthenticationRealm
extends AuthenticatingRealm {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPHeaderAuthenticationRealm.class);
    private static final Joiner JOINER = Joiner.on((String)", ");
    public static final String NAME = "http-header-authentication";
    private final ClusterConfigService clusterConfigService;
    private final AuthServiceAuthenticator authServiceAuthenticator;
    private final Set<IpSubnet> trustedProxies;

    @Inject
    public HTTPHeaderAuthenticationRealm(ClusterConfigService clusterConfigService, AuthServiceAuthenticator authServiceAuthenticator, @Named(value="trusted_proxies") Set<IpSubnet> trustedProxies) {
        this.clusterConfigService = clusterConfigService;
        this.authServiceAuthenticator = authServiceAuthenticator;
        this.trustedProxies = trustedProxies;
        this.setAuthenticationTokenClass(HttpHeadersToken.class);
        this.setCachingEnabled(false);
        this.setCredentialsMatcher((CredentialsMatcher)new AllowAllCredentialsMatcher());
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        HttpHeadersToken headersToken = (HttpHeadersToken)token;
        HTTPHeaderAuthConfig config = this.loadConfig();
        if (!config.enabled()) {
            LOG.debug("Skipping disabled HTTP header authentication");
            return null;
        }
        MultivaluedMap<String, String> headers = headersToken.getHeaders();
        Optional<String> optionalUsername = this.headerValue(headers, config.usernameHeader());
        if (optionalUsername.isPresent()) {
            String username = optionalUsername.get().trim();
            if (StringUtils.isBlank((CharSequence)username)) {
                LOG.warn("Skipping request with trusted HTTP header <{}> and blank value", (Object)config.usernameHeader());
                return null;
            }
            String remoteAddr = headersToken.getRemoteAddr();
            if (this.inTrustedSubnets(remoteAddr)) {
                return this.doAuthenticate(username, config, remoteAddr);
            }
            LOG.warn("Request with trusted HTTP header <{}={}> received from <{}> which is not in the trusted proxies: <{}>", new Object[]{config.usernameHeader(), username, remoteAddr, JOINER.join(this.trustedProxies)});
            return null;
        }
        return null;
    }

    private AuthenticationInfo doAuthenticate(String username, HTTPHeaderAuthConfig config, String remoteAddr) {
        LOG.debug("Attempting authentication for username <{}>", (Object)username);
        try {
            AuthServiceCredentials credentials = AuthServiceCredentials.createAuthenticated(username);
            AuthServiceResult result = this.authServiceAuthenticator.authenticate(credentials);
            if (result.isSuccess()) {
                LOG.debug("Successfully authenticated username <{}> for user profile <{}> with backend <{}/{}/{}>", new Object[]{result.username(), result.userProfileId(), result.backendTitle(), result.backendType(), result.backendId()});
                ShiroSecurityContext.requestSessionCreation(true);
                return this.toAuthenticationInfo(result);
            }
            LOG.warn("Failed to authenticate username <{}> from trusted HTTP header <{}> via proxy <{}>", new Object[]{result.username(), config.usernameHeader(), remoteAddr});
            return null;
        }
        catch (AuthServiceException e) {
            LOG.error("Authentication service error", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            LOG.error("Unhandled authentication error", (Throwable)e);
            return null;
        }
    }

    private AuthenticationInfo toAuthenticationInfo(AuthServiceResult result) {
        return new SimpleAccount((Object)result.userProfileId(), null, "http-header-authentication/" + result.backendType());
    }

    private HTTPHeaderAuthConfig loadConfig() {
        return this.clusterConfigService.getOrDefault(HTTPHeaderAuthConfig.class, HTTPHeaderAuthConfig.createDisabled());
    }

    private Optional<String> headerValue(MultivaluedMap<String, String> headers, @Nullable String headerName) {
        if (headerName == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((String)headers.getFirst((Object)headerName.toLowerCase(Locale.US)));
    }

    private boolean inTrustedSubnets(String remoteAddr) {
        return this.trustedProxies.stream().anyMatch(ipSubnet -> this.ipSubnetContains((IpSubnet)ipSubnet, remoteAddr));
    }

    private boolean ipSubnetContains(IpSubnet ipSubnet, String ipAddr) {
        try {
            return ipSubnet.contains(ipAddr);
        }
        catch (UnknownHostException ignored) {
            LOG.debug("Looking up remote address <{}> failed.", (Object)ipAddr);
            return false;
        }
    }
}

