/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.realm;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAccount;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.AllowAllCredentialsMatcher;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.pam.UnsupportedTokenException;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.graylog.security.authservice.AuthServiceAuthenticator;
import org.graylog.security.authservice.AuthServiceCredentials;
import org.graylog.security.authservice.AuthServiceException;
import org.graylog.security.authservice.AuthServiceResult;
import org.graylog2.security.encryption.EncryptedValue;
import org.graylog2.security.encryption.EncryptedValueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsernamePasswordRealm
extends AuthenticatingRealm {
    private static final Logger LOG = LoggerFactory.getLogger(UsernamePasswordRealm.class);
    public static final String NAME = "username-password";
    private final AuthServiceAuthenticator authenticator;
    private final EncryptedValueService encryptedValueService;
    private final String rootUsername;

    @Inject
    public UsernamePasswordRealm(AuthServiceAuthenticator authenticator, EncryptedValueService encryptedValueService, @Named(value="root_username") String rootUsername) {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)rootUsername) ? 1 : 0) != 0, (Object)"root_username cannot be null or blank");
        this.authenticator = authenticator;
        this.encryptedValueService = encryptedValueService;
        this.rootUsername = rootUsername;
        this.setAuthenticationTokenClass(UsernamePasswordToken.class);
        this.setCachingEnabled(false);
        this.setCredentialsMatcher((CredentialsMatcher)new AllowAllCredentialsMatcher());
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authToken) throws AuthenticationException {
        if (authToken instanceof UsernamePasswordToken) {
            return this.doGetAuthenticationInfo((UsernamePasswordToken)authToken);
        }
        throw new UnsupportedTokenException("Unsupported authentication token type: " + authToken.getClass());
    }

    private AuthenticationInfo doGetAuthenticationInfo(UsernamePasswordToken token) throws AuthenticationException {
        String username = token.getUsername();
        String plainPassword = String.valueOf(token.getPassword());
        if (StringUtils.isBlank((CharSequence)username) || StringUtils.isBlank((CharSequence)plainPassword)) {
            LOG.error("Username or password were empty. Not attempting authentication service authentication");
            return null;
        }
        if (this.rootUsername.equals(username)) {
            LOG.debug("Authentication services should not handle the local admin user <{}> - skipping", (Object)username);
            return null;
        }
        LOG.debug("Attempting authentication for username <{}>", (Object)username);
        try {
            EncryptedValue encryptedPassword = this.encryptedValueService.encrypt(plainPassword);
            AuthServiceResult result = this.authenticator.authenticate(AuthServiceCredentials.create(username, encryptedPassword));
            if (result.isSuccess()) {
                LOG.debug("Successfully authenticated username <{}> for user profile <{}> with backend <{}/{}/{}>", new Object[]{result.username(), result.userProfileId(), result.backendTitle(), result.backendType(), result.backendId()});
                return this.toAuthenticationInfo(result);
            }
            LOG.warn("Failed to authenticate username <{}> with backend <{}/{}/{}>", new Object[]{result.username(), result.backendTitle(), result.backendType(), result.backendId()});
            return null;
        }
        catch (AuthServiceException e) {
            LOG.error("Authentication service error", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            LOG.error("Unhandled authentication error", (Throwable)e);
            return null;
        }
    }

    private AuthenticationInfo toAuthenticationInfo(AuthServiceResult result) {
        return new SimpleAccount((Object)result.userProfileId(), null, "username-password/" + result.backendType());
    }
}

