/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.users;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog2.plugin.database.users.User;
import org.graylog2.security.MongoDbSession;
import org.graylog2.users.AutoValue_UserOverviewDTO;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class UserOverviewDTO {
    public static final String FIELD_ID = "id";
    private static final String FIELD_AUTH_SERVICE_ID = "auth_service_id";
    private static final String FIELD_AUTH_SERVICE_UID = "auth_service_uid";
    public static final String FIELD_USERNAME = "username";
    public static final String FIELD_EMAIL = "email";
    public static final String FIELD_FULL_NAME = "full_name";
    private static final String FIELD_EXTERNAL_USER = "external_user";
    private static final String FIELD_ROLES = "roles";
    private static final String FIELD_READ_ONLY = "read_only";
    private static final String FIELD_SESSION_ACTIVE = "session_active";
    private static final String FIELD_LAST_ACTIVITY = "last_activity";
    private static final String FIELD_CLIENT_ADDRESS = "client_address";
    private static final String FIELD_ACCOUNT_STATUS = "account_status";
    private static final String FIELD_SERVICE_ACCOUNT = "service_account";

    @Id
    @ObjectId
    @Nullable
    @JsonProperty(value="id")
    public abstract String id();

    @JsonProperty(value="auth_service_id")
    public abstract Optional<String> authServiceId();

    @JsonProperty(value="auth_service_uid")
    public abstract Optional<String> authServiceUid();

    @JsonProperty(value="username")
    public abstract String username();

    @JsonProperty(value="email")
    public abstract String email();

    @JsonProperty(value="full_name")
    public abstract String fullName();

    @Nullable
    @JsonProperty(value="external_user")
    public abstract Boolean externalUser();

    @ObjectId
    @JsonProperty(value="roles")
    public abstract Set<String> roles();

    @Nullable
    @JsonProperty(value="read_only")
    public abstract Boolean readOnly();

    @Nullable
    @JsonProperty(value="session_active")
    public abstract Boolean sessionActive();

    @Nullable
    @JsonProperty(value="last_activity")
    public abstract Date lastActivity();

    @Nullable
    @JsonProperty(value="client_address")
    public abstract String clientAddress();

    @JsonProperty(value="account_status")
    public abstract User.AccountStatus accountStatus();

    @JsonProperty(value="service_account")
    public abstract boolean serviceAccount();

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @JsonIgnoreProperties(value={"preferences", "permissions", "timezone", "session_timeout_ms", "startpage", "password"})
    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_UserOverviewDTO.Builder().accountStatus(User.AccountStatus.ENABLED).roles(Collections.emptySet()).serviceAccount(false);
        }

        @Id
        @ObjectId
        @JsonProperty(value="id")
        public abstract Builder id(String var1);

        @JsonProperty(value="auth_service_id")
        public abstract Builder authServiceId(@Nullable String var1);

        @JsonProperty(value="auth_service_uid")
        public abstract Builder authServiceUid(@Nullable String var1);

        @JsonProperty(value="username")
        public abstract Builder username(String var1);

        @JsonProperty(value="email")
        public abstract Builder email(String var1);

        @JsonProperty(value="full_name")
        public abstract Builder fullName(String var1);

        @JsonProperty(value="external_user")
        public abstract Builder externalUser(@Nullable Boolean var1);

        @ObjectId
        @JsonProperty(value="roles")
        public abstract Builder roles(Set<String> var1);

        @JsonProperty(value="read_only")
        public abstract Builder readOnly(@Nullable Boolean var1);

        @JsonProperty(value="session_active")
        public abstract Builder sessionActive(@Nullable Boolean var1);

        @JsonProperty(value="last_activity")
        public abstract Builder lastActivity(@Nullable Date var1);

        @JsonProperty(value="client_address")
        public abstract Builder clientAddress(@Nullable String var1);

        @JsonProperty(value="account_status")
        public abstract Builder accountStatus(User.AccountStatus var1);

        @JsonProperty(value="service_account")
        public abstract Builder serviceAccount(boolean var1);

        @JsonIgnore
        public Builder fillSession(Optional<MongoDbSession> session) {
            if (session.isPresent()) {
                MongoDbSession lastSession = session.get();
                return this.sessionActive(true).lastActivity(lastSession.getLastAccessTime()).clientAddress(lastSession.getHost());
            }
            return this;
        }

        public abstract UserOverviewDTO build();
    }
}

