/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.urls;

import com.google.common.collect.ImmutableList;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;

public class UrlEncode
extends AbstractFunction<String> {
    public static final String NAME = "urlencode";
    private final ParameterDescriptor<String, String> valueParam = ParameterDescriptor.string("value").description("The string to encode").build();
    private final ParameterDescriptor<String, Charset> charsetParam = ParameterDescriptor.type("charset", String.class, Charset.class).optional().description("The name of a supported character encoding such as \"UTF-8\" or \"US-ASCII\". Default: \"UTF-8\"").transform(Charset::forName).build();

    @Override
    public String evaluate(FunctionArgs args, EvaluationContext context) {
        String value = this.valueParam.required(args, context);
        Charset charset = this.charsetParam.optional(args, context).orElse(StandardCharsets.UTF_8);
        if (value == null) {
            return null;
        }
        try {
            return URLEncoder.encode(value, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unsupported character encoding", e);
        }
    }

    @Override
    public FunctionDescriptor<String> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(String.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.valueParam, this.charsetParam)).description("Translates a string into application/x-www-form-urlencoded format using a specific encoding scheme.").build();
    }
}

