/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice;

import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog.security.authservice.AuthServiceBackend;
import org.graylog.security.authservice.ProvisionerAction;
import org.graylog.security.authservice.ProvisionerServiceException;
import org.graylog.security.authservice.UserDetails;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.users.UserService;
import org.graylog2.users.UserImpl;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvisionerService {
    private static final Logger LOG = LoggerFactory.getLogger(ProvisionerService.class);
    private final UserService userService;
    private final DateTimeZone rootTimeZone;
    private final Map<String, ProvisionerAction.Factory<? extends ProvisionerAction>> provisionerActionFactories;

    @Inject
    public ProvisionerService(UserService userService, @Named(value="root_timezone") DateTimeZone rootTimeZone, Map<String, ProvisionerAction.Factory<? extends ProvisionerAction>> provisionerActionFactories) {
        this.userService = userService;
        this.rootTimeZone = rootTimeZone;
        this.provisionerActionFactories = provisionerActionFactories;
    }

    public UserDetails.Builder newDetails(AuthServiceBackend backend) {
        return UserDetails.builder().authServiceId(backend.backendId()).authServiceType(backend.backendType());
    }

    public UserDetails provision(UserDetails userDetails) {
        try {
            return this.doProvision(userDetails);
        }
        catch (Exception e) {
            throw new ProvisionerServiceException(userDetails, (Throwable)e);
        }
    }

    public UserDetails doProvision(UserDetails userDetails) throws Exception {
        UserDetails userDetailsWithId;
        block8: {
            String userId;
            if ("000000000000000000000001".equals(userDetails.authServiceId())) {
                LOG.debug("Skip provisioning for internal authentication service");
                return userDetails;
            }
            LOG.debug("Provisioning user profile: {}", (Object)userDetails);
            try {
                userId = this.userService.save(this.provisionUser(userDetails));
            }
            catch (ValidationException e) {
                LOG.error("Cannot update profile for user <{}> - {}", (Object)userDetails.username(), e.getErrors());
                throw e;
            }
            userDetailsWithId = userDetails.withDatabaseId(userId);
            ProvisionerAction.Factory<? extends ProvisionerAction> actionFactory = this.provisionerActionFactories.get(userDetails.authServiceType());
            if (actionFactory != null) {
                try {
                    ProvisionerAction action = actionFactory.create(userDetails.authServiceId());
                    try {
                        LOG.debug("Running provisioner action: {}", (Object)action.getClass().getCanonicalName());
                        action.provision(userDetailsWithId);
                        break block8;
                    }
                    catch (Exception e) {
                        LOG.error("Error running provisioner action <{}>", (Object)action.getClass().getCanonicalName(), (Object)e);
                        throw e;
                    }
                }
                catch (Exception e) {
                    LOG.error("Error creating provisioner action instance with factory <{}>", (Object)actionFactory.getClass().getCanonicalName());
                    throw e;
                }
            }
            LOG.debug("No provisioner action for authentication service <{}>", (Object)userDetails.authServiceType());
        }
        return userDetailsWithId;
    }

    private User provisionUser(UserDetails userDetails) {
        User user = this.userService.loadByAuthServiceUidOrUsername(userDetails.base64AuthServiceUid(), userDetails.username()).orElse(this.createUser(userDetails));
        user.setExternal(true);
        user.setAccountStatus(userDetails.accountIsEnabled() ? User.AccountStatus.ENABLED : User.AccountStatus.DISABLED);
        user.setAuthServiceId(userDetails.authServiceId());
        user.setAuthServiceUid(userDetails.base64AuthServiceUid());
        user.setName(userDetails.username());
        user.setFullName(userDetails.fullName());
        user.setEmail(userDetails.email());
        return user;
    }

    private User createUser(UserDetails userDetails) {
        User user = this.userService.create();
        user.setRoleIds(userDetails.defaultRoles());
        user.setPermissions(Collections.emptyList());
        user.setTimeZone(this.rootTimeZone);
        user.setSessionTimeoutMs(UserImpl.DEFAULT_SESSION_TIMEOUT_MS);
        if (user instanceof UserImpl) {
            ((UserImpl)user).setHashedPassword("User initially synced from " + userDetails.authServiceType());
        } else {
            LOG.warn("Received unexpected User implementation, not setting hashed password");
        }
        return user;
    }
}

