/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.entities;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNDescriptorService;
import org.graylog.grn.GRNRegistry;
import org.graylog.grn.GRNType;
import org.graylog.grn.GRNTypes;
import org.graylog.security.DBGrantService;
import org.graylog.security.entities.EntityDescriptor;
import org.graylog2.contentpacks.ContentPackService;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelType;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;

public class EntityDependencyResolver {
    private final ContentPackService contentPackService;
    private final GRNRegistry grnRegistry;
    private final GRNDescriptorService descriptorService;
    private final DBGrantService grantService;
    private static final Map<GRNType, Set<ModelType>> IGNORED_DEPENDENCIES = ImmutableMap.builder().put((Object)GRNTypes.STREAM, (Object)ImmutableSet.of((Object)ModelTypes.OUTPUT_V1)).build();

    @Inject
    public EntityDependencyResolver(ContentPackService contentPackService, GRNRegistry grnRegistry, GRNDescriptorService descriptorService, DBGrantService grantService) {
        this.contentPackService = contentPackService;
        this.grnRegistry = grnRegistry;
        this.descriptorService = descriptorService;
        this.grantService = grantService;
    }

    public ImmutableSet<EntityDescriptor> resolve(GRN entity) {
        ImmutableMap entityExcerpts = (ImmutableMap)this.contentPackService.listAllEntityExcerpts().stream().collect(ImmutableMap.toImmutableMap(e -> GRNType.create(e.type().name(), e.type().name() + ":").newGRNBuilder().entity(e.id().id()).build(), EntityExcerpt::title));
        Set<org.graylog2.contentpacks.model.entities.EntityDescriptor> descriptors = this.contentPackService.resolveEntities(Collections.singleton(((EntityDescriptor.Builder)((EntityDescriptor.Builder)org.graylog2.contentpacks.model.entities.EntityDescriptor.builder().id(ModelId.of(entity.entity()))).type(ModelType.of(entity.type(), "dashboard".equals(entity.type()) ? "2" : "1"))).build()));
        ImmutableSet dependencies = (ImmutableSet)descriptors.stream().filter(dep -> {
            Set<ModelType> ignoredDeps = IGNORED_DEPENDENCIES.getOrDefault(entity.grnType(), (Set<ModelType>)ImmutableSet.of());
            return !ignoredDeps.contains(dep.type());
        }).map(descriptor -> this.grnRegistry.newGRN(descriptor.type().name(), descriptor.id().id())).filter(dependency -> !entity.equals(dependency)).collect(ImmutableSet.toImmutableSet());
        Map<GRN, Set<GRN>> targetOwners = this.grantService.getOwnersForTargets((Collection<GRN>)dependencies);
        return (ImmutableSet)dependencies.stream().map(dependency -> {
            String title = (String)entityExcerpts.get(dependency);
            if (title == null) {
                title = "unknown dependency: <" + dependency + ">";
            }
            return EntityDescriptor.create(dependency, title, this.getOwners((Set)targetOwners.get(dependency)));
        }).collect(ImmutableSet.toImmutableSet());
    }

    private Set<EntityDescriptor.Owner> getOwners(@Nullable Set<GRN> owners) {
        return ((Set)MoreObjects.firstNonNull(owners, Collections.emptySet())).stream().map(this.descriptorService::getDescriptor).map(descriptor -> EntityDescriptor.Owner.create(descriptor.grn(), descriptor.title())).collect(Collectors.toSet());
    }
}

