/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.buffers;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.buffers.MessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Buffer {
    private static final Logger log = LoggerFactory.getLogger(Buffer.class);
    protected RingBuffer<MessageEvent> ringBuffer;
    protected int ringBufferSize;

    public boolean isEmpty() {
        return this.getUsage() == 0L;
    }

    public long getRemainingCapacity() {
        return this.ringBuffer.remainingCapacity();
    }

    public int getRingBufferSize() {
        return this.ringBufferSize;
    }

    public long getUsage() {
        if (this.ringBuffer == null) {
            return 0L;
        }
        return (long)this.ringBuffer.getBufferSize() - this.ringBuffer.remainingCapacity();
    }

    protected void insert(Message message) {
        long sequence = this.ringBuffer.next();
        MessageEvent event = (MessageEvent)this.ringBuffer.get(sequence);
        event.setMessage(message);
        this.ringBuffer.publish(sequence);
        this.afterInsert(1);
    }

    protected WaitStrategy getWaitStrategy(String waitStrategyName, String configOptionName) {
        switch (waitStrategyName) {
            case "sleeping": {
                return new SleepingWaitStrategy();
            }
            case "yielding": {
                return new YieldingWaitStrategy();
            }
            case "blocking": {
                return new BlockingWaitStrategy();
            }
            case "busy_spinning": {
                return new BusySpinWaitStrategy();
            }
        }
        log.warn("Invalid setting for [{}]: Falling back to default: BlockingWaitStrategy.", (Object)configOptionName);
        return new BlockingWaitStrategy();
    }

    protected abstract void afterInsert(int var1);

    protected void insert(Message[] messages) {
        long lo;
        int length = messages.length;
        long hi = this.ringBuffer.next(length);
        for (long sequence = lo = hi - (long)(length - 1); sequence <= hi; ++sequence) {
            MessageEvent event = (MessageEvent)this.ringBuffer.get(sequence);
            event.setMessage(messages[(int)(sequence - lo)]);
        }
        this.ringBuffer.publish(lo, hi);
        this.afterInsert(length);
    }
}

