/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security.tls;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultTLSProtocolProvider {
    public static final Set<String> DEFAULT_TLS_PROTOCOLS = ImmutableSet.of((Object)"TLSv1.2", (Object)"TLSv1.3");
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTLSProtocolProvider.class);
    private static Set<String> defaultSupportedTlsProtocols = null;

    public static synchronized Set<String> getDefaultSupportedTlsProtocols() {
        if (defaultSupportedTlsProtocols != null) {
            return defaultSupportedTlsProtocols;
        }
        HashSet tlsProtocols = Sets.newHashSet(DEFAULT_TLS_PROTOCOLS);
        try {
            ImmutableSet supportedProtocols = ImmutableSet.copyOf((Object[])SSLContext.getDefault().createSSLEngine().getSupportedProtocols());
            if (tlsProtocols.retainAll((Collection<?>)supportedProtocols)) {
                LOG.warn("JRE doesn't support all default TLS protocols. Changing <{}> to <{}>", DEFAULT_TLS_PROTOCOLS, (Object)tlsProtocols);
            }
            defaultSupportedTlsProtocols = tlsProtocols;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Failed to detect supported TLS protocols. Keeping default <{}>", DEFAULT_TLS_PROTOCOLS, (Object)e);
            defaultSupportedTlsProtocols = DEFAULT_TLS_PROTOCOLS;
        }
        return defaultSupportedTlsProtocols;
    }
}

