/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.urlwhitelist;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.graylog2.system.urlwhitelist.AutoValue_RegexWhitelistEntry;
import org.graylog2.system.urlwhitelist.WhitelistEntry;

@JsonAutoDetect
@AutoValue
public abstract class RegexWhitelistEntry
implements WhitelistEntry {
    private Pattern pattern;

    @JsonCreator
    public static RegexWhitelistEntry create(@JsonProperty(value="id") String id, @JsonProperty(value="title") String title, @JsonProperty(value="value") String value) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(value, 32);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Cannot create whitelist entry for invalid regular expression '" + value + "': " + e.getMessage(), e);
        }
        AutoValue_RegexWhitelistEntry whitelistEntry = new AutoValue_RegexWhitelistEntry(id, WhitelistEntry.Type.REGEX, title, value);
        whitelistEntry.pattern = pattern;
        return whitelistEntry;
    }

    @Override
    public boolean isWhitelisted(String url) {
        return this.pattern.matcher(url).find();
    }
}

