/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.codegen;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Primitives;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.lang.model.element.Modifier;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.Rule;
import org.graylog.plugins.pipelineprocessor.ast.RuleAstBaseListener;
import org.graylog.plugins.pipelineprocessor.ast.RuleAstWalker;
import org.graylog.plugins.pipelineprocessor.ast.expressions.AdditionExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.AndExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.ArrayLiteralExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.BooleanValuedFunctionWrapper;
import org.graylog.plugins.pipelineprocessor.ast.expressions.ComparisonExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.ConstantExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.DoubleExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.EqualityExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.Expression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.FieldAccessExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.FieldRefExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.FunctionExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.IndexedAccessExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.LongExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.MapLiteralExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.MessageRefExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.MultiplicationExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.NotExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.OrExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.SignedExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.StringExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.VarRefExpression;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.statements.VarAssignStatement;
import org.graylog.plugins.pipelineprocessor.codegen.GeneratedRule;
import org.graylog.plugins.pipelineprocessor.codegen.PipelineClassloader;
import org.graylog.plugins.pipelineprocessor.codegen.compiler.JavaCompiler;
import org.graylog.plugins.pipelineprocessor.parser.FunctionRegistry;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGenerator {
    private static final Logger log = LoggerFactory.getLogger(CodeGenerator.class);
    private final Provider<JavaCompiler> compilerProvider;

    @Inject
    public CodeGenerator(Provider<JavaCompiler> compilerProvider) {
        this.compilerProvider = compilerProvider;
    }

    public static String sourceCodeForRule(Rule rule) {
        JavaPoetListener javaPoetListener = new JavaPoetListener();
        new RuleAstWalker().walk(javaPoetListener, rule);
        return javaPoetListener.getSource();
    }

    public Class<? extends GeneratedRule> generateCompiledRule(Rule rule, PipelineClassloader ruleClassloader) {
        if (rule.id() == null) {
            throw new IllegalArgumentException("Rules must have an id to generate code for them");
        }
        String sourceCode = CodeGenerator.sourceCodeForRule(rule);
        try {
            if (log.isTraceEnabled()) {
                log.trace("Sourcecode:\n{}", (Object)sourceCode);
            }
            return ((JavaCompiler)this.compilerProvider.get()).loadFromString(ruleClassloader, "org.graylog.plugins.pipelineprocessor.$dynamic.rules.rule$" + rule.id(), sourceCode);
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to compile code\n{}", (Object)sourceCode);
            return null;
        }
    }

    private static class JavaPoetListener
    extends RuleAstBaseListener {
        public static final Set<Class<?>> OPERATOR_SAFE_TYPES = Sets.union((Set)Primitives.allPrimitiveTypes(), (Set)Primitives.allWrapperTypes());
        private long counter = 0L;
        private IdentityHashMap<Expression, CodeBlock> codeSnippet = new IdentityHashMap();
        private TypeSpec.Builder classFile;
        private JavaFile generatedFile;
        private MethodSpec.Builder when;
        private MethodSpec.Builder then;
        private MethodSpec.Builder currentMethod;
        private Set<FieldSpec> functionMembers = Sets.newHashSet();
        private Set<FieldSpec> hoistedExpressionMembers = Sets.newHashSet();
        private Set<TypeSpec> functionArgsHolderTypes = Sets.newHashSet();
        private MethodSpec.Builder constructorBuilder;
        private CodeBlock.Builder lateConstructorBlock;
        private CodeBlock.Builder hoistedConstantExpressions;
        private Set<CodeBlock> functionReferences = Sets.newHashSet();

        private JavaPoetListener() {
        }

        public String getSource() {
            return this.generatedFile.toString();
        }

        @Override
        public void enterRule(Rule rule) {
            this.classFile = TypeSpec.classBuilder((String)("rule$" + rule.id())).addSuperinterface(GeneratedRule.class).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build()).addMethod(MethodSpec.methodBuilder((String)"name").returns(String.class).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return $S", new Object[]{rule.name()}).build());
            this.constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(FunctionRegistry.class, "functionRegistry", new Modifier[0]);
            this.lateConstructorBlock = CodeBlock.builder();
            this.hoistedConstantExpressions = CodeBlock.builder();
        }

        @Override
        public void exitRule(Rule rule) {
            this.classFile.addFields(this.functionMembers);
            this.classFile.addFields(this.hoistedExpressionMembers);
            this.classFile.addTypes(this.functionArgsHolderTypes);
            this.constructorBuilder.addStatement("// resolve used functions", new Object[0]);
            this.functionReferences.forEach(block -> this.constructorBuilder.addStatement("$L", new Object[]{block}));
            this.constructorBuilder.addStatement("// function parameters", new Object[0]);
            this.constructorBuilder.addCode(this.lateConstructorBlock.build());
            this.constructorBuilder.addStatement("// constant expressions", new Object[0]);
            this.constructorBuilder.addCode(this.hoistedConstantExpressions.build());
            this.classFile.addMethod(this.constructorBuilder.build());
            this.generatedFile = JavaFile.builder((String)"org.graylog.plugins.pipelineprocessor.$dynamic.rules", (TypeSpec)this.classFile.build()).build();
        }

        @Override
        public void enterWhen(Rule rule) {
            this.currentMethod = this.when = MethodSpec.methodBuilder((String)"when").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Boolean.TYPE).addParameter(EvaluationContext.class, "context", new Modifier[]{Modifier.FINAL});
        }

        @Override
        public void exitWhen(Rule rule) {
            CodeBlock result = this.codeSnippet.getOrDefault(rule.when(), CodeBlock.of((String)"$$when", (Object[])new Object[0]));
            this.when.addStatement("return $L", new Object[]{result});
            this.classFile.addMethod(this.when.build());
            this.currentMethod = null;
        }

        @Override
        public void enterThen(Rule rule) {
            this.currentMethod = this.then = MethodSpec.methodBuilder((String)"then").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(EvaluationContext.class, "context", new Modifier[]{Modifier.FINAL});
        }

        @Override
        public void exitThen(Rule rule) {
            this.classFile.addMethod(this.then.build());
            this.currentMethod = null;
        }

        @Override
        public void exitAnd(AndExpression expr) {
            CodeBlock left = this.codeSnippet.get(expr.left());
            CodeBlock right = this.codeSnippet.get(expr.right());
            this.codeSnippet.put(expr, CodeBlock.of((String)"($L && $L)", (Object[])new Object[]{this.blockOrMissing(left, expr.left()), this.blockOrMissing(right, expr.right())}));
        }

        @Override
        public void exitOr(OrExpression expr) {
            CodeBlock left = this.codeSnippet.get(expr.left());
            CodeBlock right = this.codeSnippet.get(expr.right());
            this.codeSnippet.put(expr, CodeBlock.of((String)"($L || $L)", (Object[])new Object[]{this.blockOrMissing(left, expr.left()), this.blockOrMissing(right, expr.right())}));
        }

        @Override
        public void exitNot(NotExpression expr) {
            CodeBlock right = this.codeSnippet.get(expr.right());
            this.codeSnippet.put(expr, CodeBlock.of((String)"!$L", (Object[])new Object[]{this.blockOrMissing(right, expr.right())}));
        }

        @Override
        public void exitFieldRef(FieldRefExpression expr) {
            this.codeSnippet.put(expr, CodeBlock.of((String)"$L", (Object[])new Object[]{expr.fieldName()}));
        }

        @Override
        public void exitFieldAccess(FieldAccessExpression expr) {
            CodeBlock block;
            String fieldName;
            CodeBlock object = this.codeSnippet.get(expr.object());
            CodeBlock field = this.codeSnippet.get(expr.field());
            Object objectRef = this.blockOrMissing(object, expr.object());
            Expression o = expr.object();
            Object[] propertyDescriptors = PropertyUtils.getPropertyDescriptors((Class)o.getType());
            ImmutableMap propertyByName = Maps.uniqueIndex((Iterator)Iterators.forArray((Object[])propertyDescriptors), FeatureDescriptor::getName);
            if (propertyByName.containsKey((Object)(fieldName = field.toString()))) {
                PropertyDescriptor descriptor = (PropertyDescriptor)propertyByName.get((Object)fieldName);
                String methodName = descriptor.getReadMethod().getName();
                block = CodeBlock.of((String)"$L.$L()", (Object[])new Object[]{objectRef, methodName});
            } else if (o instanceof Map) {
                block = CodeBlock.of((String)"$L.get($S)", (Object[])new Object[]{objectRef, field});
            } else {
                log.warn("Unable to determine field accessor for property {}", (Object)field);
                block = CodeBlock.of((String)"null", (Object[])new Object[0]);
            }
            this.codeSnippet.put(expr, block);
        }

        @Override
        public void exitFunctionCall(FunctionExpression expr) {
            String functionValueVarName = this.subExpressionName();
            FunctionDescriptor<?> function = expr.getFunction().descriptor();
            String mangledFunctionName = this.functionReference(function);
            String mangledFuncArgsHolder = this.functionArgsHolder(function);
            FunctionArgs args = expr.getArgs();
            CodeBlock.Builder argAssignment = CodeBlock.builder();
            args.getArgs().forEach((name, argExpr) -> {
                Object varRef = this.blockOrMissing(this.codeSnippet.get(argExpr), (Expression)argExpr);
                CodeBlock.Builder target = argExpr.isConstant() ? this.hoistedConstantExpressions : argAssignment;
                target.addStatement("$L.setAndTransform$$$L($L)", new Object[]{mangledFuncArgsHolder, name, varRef});
            });
            this.currentMethod.addCode(argAssignment.build());
            CodeBlock functionInvocation = CodeBlock.of((String)"$L.evaluate($L, context)", (Object[])new Object[]{mangledFunctionName, mangledFuncArgsHolder});
            if (Void.class.equals(function.returnType())) {
                this.currentMethod.addStatement("$L", new Object[]{functionInvocation});
            } else {
                this.currentMethod.addStatement("$T $L = $L", new Object[]{ClassName.get(function.returnType()), functionValueVarName, functionInvocation});
            }
            this.functionMembers.add(FieldSpec.builder(expr.getFunction().getClass(), (String)mangledFunctionName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
            this.functionReferences.add(CodeBlock.of((String)"$L = ($T) functionRegistry.resolve($S)", (Object[])new Object[]{mangledFunctionName, expr.getFunction().getClass(), function.name()}));
            this.codeSnippet.put(expr, CodeBlock.of((String)"$L", (Object[])new Object[]{functionValueVarName}));
        }

        @Nonnull
        private String functionArgsHolder(FunctionDescriptor<?> function) {
            String functionArgsClassname = this.functionArgsHolderClass(function);
            String functionArgsMember = this.functionReference(function) + "$" + this.subExpressionName();
            this.classFile.addField(FieldSpec.builder((TypeName)ClassName.bestGuess((String)functionArgsClassname), (String)functionArgsMember, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
            this.lateConstructorBlock.addStatement("$L = new $L()", new Object[]{functionArgsMember, functionArgsClassname});
            return functionArgsMember;
        }

        @Nonnull
        private String functionArgsHolderClass(FunctionDescriptor<?> functionDescriptor) {
            String funcReferenceName = this.functionReference(functionDescriptor);
            String functionArgsClassname = StringUtils.capitalize((String)(funcReferenceName + "$args"));
            TypeSpec.Builder directFunctionArgs = TypeSpec.classBuilder((String)functionArgsClassname).addModifiers(new Modifier[]{Modifier.PRIVATE}).superclass((TypeName)ClassName.get(FunctionArgs.class));
            MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addStatement("super($L, $T.emptyMap())", new Object[]{funcReferenceName, ClassName.get(Collections.class)});
            CodeBlock.Builder parameterValues = CodeBlock.builder();
            functionDescriptor.params().forEach(pd -> {
                directFunctionArgs.addMethod(MethodSpec.methodBuilder((String)("setAndTransform$" + pd.name())).returns(TypeName.VOID).addParameter((TypeName)ClassName.get(pd.type()), "arg$" + pd.name(), new Modifier[0]).addStatement("transformed$$$L = transformer$$$L.apply(arg$$$L)", new Object[]{pd.name(), pd.name(), pd.name()}).build());
                ParameterizedTypeName transformerType = ParameterizedTypeName.get(Function.class, (Type[])new Type[]{pd.type(), pd.transformedType()});
                directFunctionArgs.addField((TypeName)transformerType, "transformer$" + pd.name(), new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                directFunctionArgs.addField((TypeName)ClassName.get(pd.transformedType()), "transformed$" + pd.name(), new Modifier[0]);
                constructorBuilder.addStatement("transformer$$$L = ($T) $L.descriptor().param($S).transform()", new Object[]{pd.name(), transformerType, funcReferenceName, pd.name()});
                parameterValues.add(CodeBlock.builder().beginControlFlow("case $S:", new Object[]{pd.name()}).addStatement("return transformed$$$L", new Object[]{pd.name()}).endControlFlow().build());
            });
            directFunctionArgs.addMethod(MethodSpec.methodBuilder((String)"getPreComputedValue").returns((TypeName)TypeName.OBJECT).addParameter(String.class, "name", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(CodeBlock.builder().beginControlFlow("switch (name)", new Object[0]).add(parameterValues.build()).endControlFlow().addStatement("return null", new Object[0]).build()).build());
            directFunctionArgs.addMethod(constructorBuilder.build());
            TypeSpec holder = directFunctionArgs.build();
            if (!this.functionArgsHolderTypes.contains(holder)) {
                this.functionArgsHolderTypes.add(holder);
            }
            return functionArgsClassname;
        }

        @Nonnull
        private String functionReference(FunctionDescriptor<?> function) {
            return "func$" + function.name();
        }

        @Override
        public void exitEquality(EqualityExpression expr) {
            String intermediateName = this.subExpressionName();
            CodeBlock leftBlock = this.codeSnippet.get(expr.left());
            CodeBlock rightBlock = this.codeSnippet.get(expr.right());
            Class leftType = expr.left().getType();
            Class rightType = expr.right().getType();
            boolean useOperator = false;
            if (OPERATOR_SAFE_TYPES.contains(leftType) && OPERATOR_SAFE_TYPES.contains(rightType)) {
                useOperator = true;
            }
            String statement = "boolean $L = ";
            boolean checkEquality = expr.isCheckEquality();
            if (useOperator) {
                statement = statement + "$L " + (checkEquality ? "==" : "!=") + " $L";
                this.currentMethod.addStatement(statement, new Object[]{intermediateName, this.blockOrMissing(leftBlock, expr.left()), this.blockOrMissing(rightBlock, expr.right())});
            } else {
                if (DateTime.class.equals((Object)leftType)) {
                    if (DateTime.class.equals((Object)rightType)) {
                        this.codeSnippet.putIfAbsent(expr, CodeBlock.of((String)"$L.isEqual($L)", (Object[])new Object[]{leftBlock, rightBlock}));
                        return;
                    }
                } else if (Period.class.equals((Object)leftType) && Period.class.equals((Object)rightType)) {
                    this.codeSnippet.putIfAbsent(expr, CodeBlock.of((String)"$L.toDuration().equals($L.toDuration())", (Object[])new Object[]{leftBlock, rightBlock}));
                    return;
                }
                statement = statement + (checkEquality ? "" : "!") + "$T.equals($L, $L)";
                this.currentMethod.addStatement(statement, new Object[]{intermediateName, ClassName.get(Objects.class), this.blockOrMissing(leftBlock, expr.left()), this.blockOrMissing(rightBlock, expr.right())});
            }
            this.codeSnippet.put(expr, CodeBlock.of((String)"$L", (Object[])new Object[]{intermediateName}));
        }

        @Override
        public void exitComparison(ComparisonExpression expr) {
            CodeBlock left = this.codeSnippet.get(expr.left());
            CodeBlock right = this.codeSnippet.get(expr.right());
            Class leftType = expr.left().getType();
            Class rightType = expr.right().getType();
            if (DateTime.class.equals((Object)leftType)) {
                if (DateTime.class.equals((Object)rightType)) {
                    CodeBlock block;
                    switch (expr.getOperator()) {
                        case ">": {
                            block = CodeBlock.of((String)"$L.isAfter($L)", (Object[])new Object[]{left, right});
                            break;
                        }
                        case ">=": {
                            block = CodeBlock.of((String)"!$L.isBefore($L)", (Object[])new Object[]{left, right});
                            break;
                        }
                        case "<": {
                            block = CodeBlock.of((String)"$L.isBefore($L)", (Object[])new Object[]{left, right});
                            break;
                        }
                        case "<=": {
                            block = CodeBlock.of((String)"!$L.isAfter($L)", (Object[])new Object[]{left, right});
                            break;
                        }
                        default: {
                            block = null;
                        }
                    }
                    if (block != null) {
                        this.codeSnippet.putIfAbsent(expr, block);
                        return;
                    }
                }
            } else if (Period.class.equals((Object)leftType) && Period.class.equals((Object)rightType)) {
                this.codeSnippet.putIfAbsent(expr, CodeBlock.of((String)("($L.toDuration().getMillis() " + expr.getOperator() + " $L.toDuration().getMillis())"), (Object[])new Object[]{this.blockOrMissing(left, expr.left()), this.blockOrMissing(right, expr.right())}));
                return;
            }
            this.codeSnippet.putIfAbsent(expr, CodeBlock.of((String)("($L " + expr.getOperator() + " $L)"), (Object[])new Object[]{this.blockOrMissing(left, expr.left()), this.blockOrMissing(right, expr.right())}));
        }

        @Override
        public void exitBooleanFuncWrapper(BooleanValuedFunctionWrapper expr) {
            CodeBlock embeddedExpr = this.codeSnippet.get(expr.expression());
            this.codeSnippet.put(expr, CodeBlock.of((String)"$L", (Object[])new Object[]{this.blockOrMissing(embeddedExpr, expr.expression())}));
        }

        @Override
        public void exitConstant(ConstantExpression expr) {
            this.codeSnippet.putIfAbsent(expr, CodeBlock.of((String)"$L", (Object[])new Object[]{expr.evaluateUnsafe()}));
        }

        @Override
        public void exitString(StringExpression expr) {
            this.codeSnippet.putIfAbsent(expr, CodeBlock.of((String)"$S", (Object[])new Object[]{expr.evaluateUnsafe()}));
        }

        @Override
        public void exitLong(LongExpression expr) {
            this.codeSnippet.putIfAbsent(expr, CodeBlock.of((String)"$LL", (Object[])new Object[]{expr.evaluateUnsafe()}));
        }

        @Override
        public void exitDouble(DoubleExpression expr) {
            this.codeSnippet.putIfAbsent(expr, CodeBlock.of((String)"$Ld", (Object[])new Object[]{expr.evaluateUnsafe()}));
        }

        @Override
        public void exitMessageRef(MessageRefExpression expr) {
            Object field = this.blockOrMissing(this.codeSnippet.get(expr.getFieldExpr()), expr.getFieldExpr());
            this.codeSnippet.putIfAbsent(expr, CodeBlock.of((String)"context.currentMessage().getField($S)", (Object[])new Object[]{field}));
        }

        @Override
        public void exitVariableAssignStatement(VarAssignStatement assign) {
            Object value = this.blockOrMissing(this.codeSnippet.get(assign.getValueExpression()), assign.getValueExpression());
            Class type = assign.getValueExpression().getType();
            this.hoistedExpressionMembers.add(FieldSpec.builder((Type)type, (String)("var$" + assign.getName()), (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
            if (assign.getValueExpression().isConstant()) {
                this.hoistedConstantExpressions.addStatement("var$$$L = $L", new Object[]{assign.getName(), value});
            } else {
                this.currentMethod.addStatement("var$$$L = $L", new Object[]{assign.getName(), value});
            }
        }

        @Override
        public void exitVariableReference(VarRefExpression expr) {
            this.codeSnippet.putIfAbsent(expr, CodeBlock.of((String)"var$$$L", (Object[])new Object[]{expr.varName()}));
        }

        @Override
        public void exitMapLiteral(MapLiteralExpression expr) {
            String mapName = "mapLiteral$" + this.subExpressionName();
            boolean constantMap = expr.isConstant();
            if (constantMap) {
                this.hoistedExpressionMembers.add(FieldSpec.builder(Map.class, (String)mapName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
                this.hoistedConstantExpressions.addStatement("$L = $T.newHashMap()", new Object[]{mapName, Maps.class});
            } else {
                this.currentMethod.addStatement("$T $L = $T.newHashMap()", new Object[]{Map.class, mapName, Maps.class});
            }
            expr.entries().forEach(entry -> {
                String code = "$L.put($S, $L)";
                Object[] args = new Object[]{mapName, entry.getKey(), this.blockOrMissing(this.codeSnippet.get(entry.getValue()), (Expression)entry.getValue())};
                if (constantMap) {
                    this.hoistedConstantExpressions.addStatement("$L.put($S, $L)", args);
                } else {
                    this.currentMethod.addStatement("$L.put($S, $L)", args);
                }
            });
            this.codeSnippet.putIfAbsent(expr, CodeBlock.of((String)"$L", (Object[])new Object[]{mapName}));
        }

        @Override
        public void exitArrayLiteral(ArrayLiteralExpression expr) {
            String listName = "arrayLiteral$" + this.subExpressionName();
            boolean constantList = expr.isConstant();
            ImmutableList.Builder elementsBuilder = ImmutableList.builder();
            expr.children().forEach(expression -> elementsBuilder.add(this.blockOrMissing(this.codeSnippet.get(expression), (Expression)expression)));
            ImmutableList elements = elementsBuilder.build();
            if (constantList) {
                this.hoistedExpressionMembers.add(FieldSpec.builder(List.class, (String)listName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
            }
            String assignmentFormat = "$L = $T.newArrayList(" + Stream.generate(() -> "$L").limit(elements.size()).reduce((arg_0, arg_1) -> JavaPoetListener.lambda$exitArrayLiteral$6(Joiner.on((String)", "), arg_0, arg_1)).orElseGet(() -> "$") + ")";
            ArrayList args = Lists.newArrayList((Object[])new Object[]{ArrayList.class, listName, Lists.class});
            args.addAll(elements);
            if (constantList) {
                this.hoistedConstantExpressions.addStatement(assignmentFormat, args.subList(1, args.size()).toArray());
            } else {
                this.currentMethod.addStatement("$T " + assignmentFormat, args.toArray());
            }
            this.codeSnippet.putIfAbsent(expr, CodeBlock.of((String)"$L", (Object[])new Object[]{listName}));
        }

        @Override
        public void exitAddition(AdditionExpression expr) {
            Object leftBlock = this.blockOrMissing(this.codeSnippet.get(expr.left()), expr.left());
            Object rightBlock = this.blockOrMissing(this.codeSnippet.get(expr.right()), expr.right());
            Class leftType = expr.left().getType();
            Class rightType = expr.right().getType();
            if (DateTime.class.equals((Object)leftType)) {
                if (DateTime.class.equals((Object)rightType)) {
                    if (expr.isPlus()) {
                        throw new IllegalStateException("Cannot add two dates, this is a parser bug");
                    }
                    this.codeSnippet.putIfAbsent(expr, CodeBlock.of((String)"new $T($L, $L)", (Object[])new Object[]{Duration.class, leftBlock, rightBlock}));
                } else if (Period.class.equals((Object)rightType)) {
                    this.codeSnippet.putIfAbsent(expr, CodeBlock.of((String)("$L." + (expr.isPlus() ? "plus" : "minus") + "($L)"), (Object[])new Object[]{leftBlock, rightBlock}));
                }
                return;
            }
            if (Period.class.equals((Object)leftType)) {
                if (DateTime.class.equals((Object)rightType)) {
                    this.codeSnippet.putIfAbsent(expr, CodeBlock.of((String)("$L." + (expr.isPlus() ? "plus" : "minus") + "($L)"), (Object[])new Object[]{rightBlock, leftBlock}));
                } else if (Period.class.equals((Object)rightType)) {
                    this.codeSnippet.putIfAbsent(expr, CodeBlock.of((String)("$L." + (expr.isPlus() ? "plus" : "minus") + "($L)"), (Object[])new Object[]{leftBlock, rightBlock}));
                }
                return;
            }
            this.codeSnippet.putIfAbsent(expr, CodeBlock.of((String)("$L " + (expr.isPlus() ? "+" : "-") + " $L"), (Object[])new Object[]{leftBlock, rightBlock}));
        }

        @Override
        public void exitMultiplication(MultiplicationExpression expr) {
            Object leftBlock = this.blockOrMissing(this.codeSnippet.get(expr.left()), expr.left());
            Object rightBlock = this.blockOrMissing(this.codeSnippet.get(expr.right()), expr.right());
            this.codeSnippet.putIfAbsent(expr, CodeBlock.of((String)("$L " + expr.getOperator() + " $L"), (Object[])new Object[]{leftBlock, rightBlock}));
        }

        @Override
        public void exitSigned(SignedExpression expr) {
            Object rightBlock = this.blockOrMissing(this.codeSnippet.get(expr.right()), expr.right());
            this.codeSnippet.putIfAbsent(expr, CodeBlock.of((String)((expr.isPlus() ? "+" : "-") + "$L"), (Object[])new Object[]{rightBlock}));
        }

        @Override
        public void exitIndexedAccess(IndexedAccessExpression expr) {
            CodeBlock block;
            Expression indexableObject = expr.getIndexableObject();
            Expression index = expr.getIndex();
            Object objectBlock = this.blockOrMissing(this.codeSnippet.get(indexableObject), indexableObject);
            Object indexBlock = this.blockOrMissing(this.codeSnippet.get(index), index);
            Class indexType = index.getType();
            Class indexableObjectType = indexableObject.getType();
            if (Long.class.equals((Object)indexType)) {
                if (indexableObjectType.isArray()) {
                    block = CodeBlock.of((String)"Arrays.get($L, $L)", (Object[])new Object[]{objectBlock, indexBlock});
                } else if (List.class.isAssignableFrom(indexableObjectType)) {
                    block = CodeBlock.of((String)"$L.get($T.saturatedCast($L))", (Object[])new Object[]{objectBlock, ClassName.get(Ints.class), indexBlock});
                } else if (Iterable.class.isAssignableFrom(indexableObjectType)) {
                    block = CodeBlock.of((String)"$T.get($L, $L)", (Object[])new Object[]{ClassName.get(Iterables.class), objectBlock, indexBlock});
                } else {
                    log.error("Unhandled indexable object type: {}", (Object)indexableObject);
                    block = null;
                }
            } else if (String.class.equals((Object)indexType) && Map.class.isAssignableFrom(indexableObjectType)) {
                block = CodeBlock.of((String)"$L.get($L)", (Object[])new Object[]{objectBlock, indexBlock});
            } else {
                log.error("Invalid index type: {}", (Object)index);
                block = null;
            }
            this.codeSnippet.putIfAbsent(expr, block);
        }

        @Nonnull
        private String subExpressionName() {
            return "im$" + this.counter++;
        }

        private Object blockOrMissing(Object block, Expression fallBackExpression) {
            if (block == null) {
                log.warn("Missing code snippet for {}: ", (Object)fallBackExpression.nodeType(), (Object)fallBackExpression);
            }
            return MoreObjects.firstNonNull((Object)block, (Object)fallBackExpression);
        }

        private static /* synthetic */ String lambda$exitArrayLiteral$6(Joiner rec$, Object x$0, Object x$1) {
            return rec$.join(x$0, x$1, new Object[0]);
        }
    }
}

