/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.export;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog.plugins.views.search.export.ExportJob;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

public class ExportJobService {
    protected final JacksonDBCollection<ExportJob, ObjectId> db;

    @Inject
    public ExportJobService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        this.db = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection("export_jobs"), ExportJob.class, ObjectId.class, (ObjectMapper)mapper.get());
        this.db.createIndex((DBObject)new BasicDBObject("created_at", (Object)1), (DBObject)new BasicDBObject("expireAfterSeconds", (Object)TimeUnit.HOURS.toSeconds(1L)));
    }

    public Optional<ExportJob> get(String id) {
        if (!ObjectId.isValid((String)id)) {
            return Optional.empty();
        }
        return Optional.ofNullable((ExportJob)this.db.findOneById((Object)new ObjectId(id)));
    }

    public String save(ExportJob exportJob) {
        WriteResult save = this.db.insert((Object)exportJob);
        return ((ObjectId)save.getSavedId()).toHexString();
    }
}

