/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice.test;

import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.graylog.security.authservice.AuthServiceBackend;
import org.graylog.security.authservice.AuthServiceBackendDTO;
import org.graylog.security.authservice.AuthServiceCredentials;
import org.graylog.security.authservice.DBAuthServiceBackendService;
import org.graylog.security.authservice.test.AuthServiceBackendTestRequest;
import org.graylog.security.authservice.test.AuthServiceBackendTestResult;

public class AuthServiceBackendTestService {
    private final DBAuthServiceBackendService dbService;
    private final Map<String, AuthServiceBackend.Factory<? extends AuthServiceBackend>> backendFactories;

    @Inject
    public AuthServiceBackendTestService(DBAuthServiceBackendService dbService, Map<String, AuthServiceBackend.Factory<? extends AuthServiceBackend>> backendFactories) {
        this.dbService = dbService;
        this.backendFactories = backendFactories;
    }

    public AuthServiceBackendTestResult testConnection(AuthServiceBackendTestRequest request) {
        Optional<AuthServiceBackend> backend = this.createNewBackend(request);
        if (backend.isPresent()) {
            return backend.get().testConnection(this.getExistingBackendConfig(request).orElse(null));
        }
        return AuthServiceBackendTestResult.createFailure("Unknown authentication service type: " + request.backendConfiguration().config().type());
    }

    public AuthServiceBackendTestResult testLogin(AuthServiceBackendTestRequest request) {
        Optional<AuthServiceBackend> newBackend = this.createNewBackend(request);
        if (!request.userLogin().isPresent()) {
            return AuthServiceBackendTestResult.createFailure("Missing username and password");
        }
        if (newBackend.isPresent()) {
            return newBackend.get().testLogin(AuthServiceCredentials.create(request.userLogin().get().username(), request.userLogin().get().password()), this.getExistingBackendConfig(request).orElse(null));
        }
        return AuthServiceBackendTestResult.createFailure("Unknown authentication service type: " + request.backendConfiguration().config().type());
    }

    private Optional<AuthServiceBackendDTO> getExistingBackendConfig(AuthServiceBackendTestRequest request) {
        if (request.backendId().isPresent()) {
            return this.dbService.get(request.backendId().get());
        }
        return Optional.empty();
    }

    private Optional<AuthServiceBackend> createNewBackend(AuthServiceBackendTestRequest request) {
        AuthServiceBackendDTO newBackend = request.backendConfiguration();
        AuthServiceBackend.Factory<? extends AuthServiceBackend> backendFactory = this.backendFactories.get(newBackend.config().type());
        if (backendFactory == null) {
            return Optional.empty();
        }
        return Optional.of(backendFactory.create(newBackend));
    }
}

