/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.rest;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.constraints.NotBlank;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.events.notifications.DBNotificationService;
import org.graylog.events.notifications.NotificationDto;
import org.graylog.events.notifications.NotificationResourceHandler;
import org.graylog.security.UserContext;
import org.graylog2.alarmcallbacks.EmailAlarmCallback;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.database.PaginatedList;
import org.graylog2.plugin.alarms.callbacks.AlarmCallback;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.plugin.rest.ValidationResult;
import org.graylog2.rest.models.PaginatedResponse;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryField;
import org.graylog2.search.SearchQueryParser;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="Events/Notifications", description="Manage event notifications")
@Path(value="/events/notifications")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RequiresAuthentication
public class EventNotificationsResource
extends RestResource
implements PluginRestResource {
    private static final ImmutableMap<String, SearchQueryField> SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"id", (Object)SearchQueryField.create("_id", SearchQueryField.Type.OBJECT_ID)).put((Object)"title", (Object)SearchQueryField.create("title")).put((Object)"description", (Object)SearchQueryField.create("description")).build();
    private final DBNotificationService dbNotificationService;
    private final Set<AlarmCallback> availableLegacyAlarmCallbacks;
    private final SearchQueryParser searchQueryParser;
    private final NotificationResourceHandler resourceHandler;

    @Inject
    public EventNotificationsResource(DBNotificationService dbNotificationService, Set<AlarmCallback> availableLegacyAlarmCallbacks, NotificationResourceHandler resourceHandler) {
        this.dbNotificationService = dbNotificationService;
        this.availableLegacyAlarmCallbacks = availableLegacyAlarmCallbacks;
        this.resourceHandler = resourceHandler;
        this.searchQueryParser = new SearchQueryParser("title", (Map<String, SearchQueryField>)SEARCH_FIELD_MAPPING);
    }

    @GET
    @ApiOperation(value="List all available notifications")
    public PaginatedResponse<NotificationDto> listNotifications(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query) {
        SearchQuery searchQuery = this.searchQueryParser.parse(query);
        PaginatedList<NotificationDto> result = this.dbNotificationService.searchPaginated(searchQuery, notification -> this.isPermitted("eventnotifications:read", notification.id()), "title", page, perPage);
        return PaginatedResponse.create("notifications", result, query);
    }

    @GET
    @Path(value="/{notificationId}")
    @ApiOperation(value="Get a notification")
    public NotificationDto get(@ApiParam(name="notificationId") @PathParam(value="notificationId") @NotBlank String notificationId) {
        this.checkPermission("eventnotifications:read", notificationId);
        return (NotificationDto)this.dbNotificationService.get(notificationId).orElseThrow(() -> new NotFoundException("Notification " + notificationId + " doesn't exist"));
    }

    @POST
    @ApiOperation(value="Create new notification definition")
    @AuditEvent(type="events:notification:create")
    @RequiresPermissions(value={"eventnotifications:create"})
    public Response create(@ApiParam(name="JSON Body") NotificationDto dto, @Context UserContext userContext) {
        ValidationResult validationResult = dto.validate();
        if (validationResult.failed()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)validationResult).build();
        }
        return Response.ok().entity((Object)this.resourceHandler.create(dto, Optional.ofNullable(userContext.getUser()))).build();
    }

    @PUT
    @Path(value="/{notificationId}")
    @ApiOperation(value="Update existing notification")
    @AuditEvent(type="events:notification:update")
    public Response update(@ApiParam(name="notificationId") @PathParam(value="notificationId") @NotBlank String notificationId, @ApiParam(name="JSON Body") NotificationDto dto) {
        this.checkPermission("eventnotifications:edit", notificationId);
        this.dbNotificationService.get(notificationId).orElseThrow(() -> new NotFoundException("Notification " + notificationId + " doesn't exist"));
        if (!notificationId.equals(dto.id())) {
            throw new BadRequestException("Notification IDs don't match");
        }
        ValidationResult validationResult = dto.validate();
        if (validationResult.failed()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)validationResult).build();
        }
        return Response.ok().entity((Object)this.resourceHandler.update(dto)).build();
    }

    @DELETE
    @Path(value="/{notificationId}")
    @ApiOperation(value="Delete a notification")
    @AuditEvent(type="events:notification:delete")
    public void delete(@ApiParam(name="notificationId") @PathParam(value="notificationId") @NotBlank String notificationId) {
        this.checkPermission("eventnotifications:delete", notificationId);
        this.resourceHandler.delete(notificationId);
    }

    @POST
    @Timed
    @Path(value="/{notificationId}/test")
    @ApiOperation(value="Send a test alert for a given event notification")
    @ApiResponses(value={@ApiResponse(code=404, message="Event notification not found."), @ApiResponse(code=500, message="Error while testing event notification")})
    @NoAuditEvent(value="only used to test event notifications")
    public Response test(@ApiParam(name="notificationId", value="The event notification id to send a test alert for.", required=true) @PathParam(value="notificationId") @NotBlank String notificationId) {
        this.checkPermission("eventnotifications:edit", notificationId);
        NotificationDto notificationDto = (NotificationDto)this.dbNotificationService.get(notificationId).orElseThrow(() -> new NotFoundException("Notification " + notificationId + " doesn't exist"));
        this.resourceHandler.test(notificationDto, this.getSubject().getPrincipal().toString());
        return Response.ok().build();
    }

    @POST
    @Timed
    @Path(value="/test")
    @RequiresPermissions(value={"eventnotifications:create"})
    @ApiOperation(value="Send a test alert for a given event notification")
    @ApiResponses(value={@ApiResponse(code=400, message="Event notification is invalid."), @ApiResponse(code=500, message="Error while testing event notification")})
    @NoAuditEvent(value="only used to test event notifications")
    public Response test(@ApiParam(name="JSON Body") NotificationDto dto) {
        this.checkPermission("eventnotifications:create");
        ValidationResult validationResult = dto.validate();
        if (validationResult.failed()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)validationResult).build();
        }
        this.resourceHandler.test(dto, this.getSubject().getPrincipal().toString());
        return Response.ok().build();
    }

    @GET
    @Path(value="/legacy/types")
    @ApiOperation(value="List all available legacy alarm callback types")
    public Response legacyTypes() {
        ImmutableMap.Builder typesBuilder = ImmutableMap.builder();
        for (AlarmCallback availableAlarmCallback : this.availableLegacyAlarmCallbacks) {
            typesBuilder.put((Object)availableAlarmCallback.getClass().getCanonicalName(), (Object)ImmutableMap.of((Object)"name", (Object)availableAlarmCallback.getName(), (Object)"configuration", this.getConfigurationRequest(availableAlarmCallback).asList()));
        }
        return Response.ok((Object)ImmutableMap.of((Object)"types", (Object)typesBuilder.build())).build();
    }

    private ConfigurationRequest getConfigurationRequest(AlarmCallback callback) {
        if (callback instanceof EmailAlarmCallback && this.isPermitted("users:list")) {
            return ((EmailAlarmCallback)callback).getEnrichedRequestedConfiguration();
        }
        return callback.getRequestedConfiguration();
    }
}

