/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.debug;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.ImmutableList;
import javax.inject.Inject;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;

public class MetricCounterIncrement
extends AbstractFunction<Void> {
    public static final String NAME = "metric_counter_inc";
    private final ParameterDescriptor<String, Counter> nameParam = ParameterDescriptor.string("name", Counter.class).description("The counter metric name, will always be prefixed with 'org.graylog.rulemetrics.'").transform(name -> metricRegistry.counter(MetricRegistry.name((String)"org.graylog.rulemetrics", (String[])new String[]{name}))).build();
    private final ParameterDescriptor<Long, Long> valueParam = ParameterDescriptor.integer("value").description("Value to increment the counter by").optional().build();

    @Inject
    public MetricCounterIncrement(MetricRegistry metricRegistry) {
    }

    @Override
    public Void evaluate(FunctionArgs args, EvaluationContext context) {
        Counter counter = this.nameParam.required(args, context);
        Long aLong = this.valueParam.optional(args, context).orElse(1L);
        counter.inc(aLong.longValue());
        return null;
    }

    @Override
    public FunctionDescriptor<Void> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Void.class).description("").params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.nameParam, this.valueParam)).build();
    }
}

