/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.utilities.date;

import com.google.common.collect.Maps;
import com.joestelmach.natty.DateGroup;
import com.joestelmach.natty.Parser;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.graylog2.plugin.Tools;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class NaturalDateParser {
    private final TimeZone timeZone;
    private final DateTimeZone dateTimeZone;

    public NaturalDateParser() {
        this("Etc/UTC");
    }

    public NaturalDateParser(String timeZone) throws IllegalArgumentException {
        if (!this.isValidTimeZone(timeZone)) {
            throw new IllegalArgumentException("Invalid timeZone: " + timeZone);
        }
        this.timeZone = TimeZone.getTimeZone(timeZone);
        this.dateTimeZone = DateTimeZone.forTimeZone((TimeZone)this.timeZone);
    }

    boolean isValidTimeZone(String timeZone) {
        return Arrays.stream(TimeZone.getAvailableIDs()).anyMatch(id -> id.equals(timeZone));
    }

    public Result parse(String string) throws DateNotParsableException {
        return this.parse(string, new Date());
    }

    Result parse(String string, Date referenceDate) throws DateNotParsableException {
        Date from = null;
        Date to = null;
        Parser parser = new Parser(this.timeZone);
        List groups = parser.parse(string, referenceDate);
        if (!groups.isEmpty()) {
            List dates = ((DateGroup)groups.get(0)).getDates();
            Collections.sort(dates);
            if (dates.size() >= 1) {
                from = (Date)dates.get(0);
            }
            if (dates.size() >= 2) {
                to = (Date)dates.get(1);
            }
        } else {
            throw new DateNotParsableException("Unparsable date: " + string);
        }
        return new Result(from, to, this.dateTimeZone);
    }

    public static class DateNotParsableException
    extends Exception {
        public DateNotParsableException(String message) {
            super(message);
        }
    }

    public static class Result {
        private final DateTime from;
        private final DateTime to;
        private final DateTimeZone dateTimeZone;

        public Result(Date from, Date to, DateTimeZone dateTimeZone) {
            this.dateTimeZone = dateTimeZone;
            this.from = from != null ? new DateTime((Object)from, this.dateTimeZone) : Tools.now(this.dateTimeZone);
            this.to = to != null ? new DateTime((Object)to, this.dateTimeZone) : Tools.now(this.dateTimeZone);
        }

        public DateTime getFrom() {
            return this.from;
        }

        public DateTime getTo() {
            return this.to;
        }

        public DateTimeZone getDateTimeZone() {
            return this.dateTimeZone;
        }

        public Map<String, String> asMap() {
            HashMap result = Maps.newHashMap();
            result.put("from", this.dateFormat(this.getFrom()));
            result.put("to", this.dateFormat(this.getTo()));
            return result;
        }

        private String dateFormat(DateTime x) {
            return x.toString(Tools.ES_DATE_FORMAT_NO_MS_FORMATTER.withZone(this.dateTimeZone));
        }
    }
}

