/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.bindings.providers;

import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.github.zafarkhaja.semver.Version;
import com.vdurmont.semver4j.Requirement;
import com.vdurmont.semver4j.Semver;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNDeserializer;
import org.graylog.grn.GRNKeyDeserializer;
import org.graylog.grn.GRNRegistry;
import org.graylog2.database.ObjectIdSerializer;
import org.graylog2.jackson.AutoValueSubtypeResolver;
import org.graylog2.jackson.JodaTimePeriodKeyDeserializer;
import org.graylog2.jackson.SemverDeserializer;
import org.graylog2.jackson.SemverRequirementDeserializer;
import org.graylog2.jackson.SemverRequirementSerializer;
import org.graylog2.jackson.SemverSerializer;
import org.graylog2.jackson.VersionDeserializer;
import org.graylog2.jackson.VersionSerializer;
import org.graylog2.plugin.inject.JacksonSubTypes;
import org.graylog2.security.encryption.EncryptedValue;
import org.graylog2.security.encryption.EncryptedValueDeserializer;
import org.graylog2.security.encryption.EncryptedValueSerializer;
import org.graylog2.security.encryption.EncryptedValueService;
import org.graylog2.shared.jackson.SizeSerializer;
import org.graylog2.shared.plugins.GraylogClassLoader;
import org.graylog2.shared.rest.RangeJsonSerializer;
import org.joda.time.Period;

@Singleton
public class ObjectMapperProvider
implements Provider<ObjectMapper> {
    protected final ObjectMapper objectMapper;

    public ObjectMapperProvider() {
        this(ObjectMapperProvider.class.getClassLoader(), Collections.emptySet(), new EncryptedValueService(UUID.randomUUID().toString()), GRNRegistry.createWithBuiltinTypes());
    }

    public ObjectMapperProvider(ClassLoader classLoader, Set<NamedType> subtypes) {
        this(classLoader, subtypes, new EncryptedValueService(UUID.randomUUID().toString()), GRNRegistry.createWithBuiltinTypes());
    }

    @Inject
    public ObjectMapperProvider(@GraylogClassLoader ClassLoader classLoader, @JacksonSubTypes Set<NamedType> subtypes, EncryptedValueService encryptedValueService, GRNRegistry grnRegistry) {
        ObjectMapper mapper = new ObjectMapper();
        TypeFactory typeFactory = mapper.getTypeFactory().withClassLoader(classLoader);
        AutoValueSubtypeResolver subtypeResolver = new AutoValueSubtypeResolver();
        this.objectMapper = mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE).disable(DeserializationFeature.FAIL_ON_MISSING_EXTERNAL_TYPE_ID_PROPERTY).setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategy.SnakeCaseStrategy()).setSubtypeResolver((SubtypeResolver)subtypeResolver).setTypeFactory(typeFactory).registerModule((Module)new GuavaModule()).registerModule((Module)new JodaModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.SECONDS, false)).registerModule((Module)new SimpleModule("Graylog").addKeyDeserializer(Period.class, (KeyDeserializer)new JodaTimePeriodKeyDeserializer()).addKeyDeserializer(GRN.class, (KeyDeserializer)new GRNKeyDeserializer(grnRegistry)).addSerializer((JsonSerializer)new RangeJsonSerializer()).addSerializer((JsonSerializer)new SizeSerializer()).addSerializer((JsonSerializer)new ObjectIdSerializer()).addSerializer((JsonSerializer)new VersionSerializer()).addSerializer((JsonSerializer)new SemverSerializer()).addSerializer((JsonSerializer)new SemverRequirementSerializer()).addSerializer(GRN.class, (JsonSerializer)new ToStringSerializer()).addSerializer(EncryptedValue.class, (JsonSerializer)new EncryptedValueSerializer()).addDeserializer(Version.class, (JsonDeserializer)new VersionDeserializer()).addDeserializer(Semver.class, (JsonDeserializer)new SemverDeserializer()).addDeserializer(Requirement.class, (JsonDeserializer)new SemverRequirementDeserializer()).addDeserializer(GRN.class, (JsonDeserializer)new GRNDeserializer(grnRegistry)).addDeserializer(EncryptedValue.class, (JsonDeserializer)new EncryptedValueDeserializer(encryptedValueService)));
        if (subtypes != null) {
            this.objectMapper.registerSubtypes(subtypes.toArray(new NamedType[0]));
        }
    }

    public ObjectMapper get() {
        return this.objectMapper;
    }
}

