/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.views.QualifyingViewsService;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog.plugins.views.search.views.ViewParameterSummaryDTO;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="Views/QualifyingViews")
@Path(value="/views/forValue")
@Produces(value={"application/json"})
@RequiresAuthentication
public class QualifyingViewsResource
extends RestResource
implements PluginRestResource {
    private final QualifyingViewsService qualifyingViewsService;

    @Inject
    public QualifyingViewsResource(QualifyingViewsService qualifyingViewsService) {
        this.qualifyingViewsService = qualifyingViewsService;
    }

    @POST
    @ApiOperation(value="Get all views that match given parameter value")
    @NoAuditEvent(value="Only returning matching views, not changing any data")
    public Collection<ViewParameterSummaryDTO> forParameter() {
        return this.qualifyingViewsService.forValue().stream().filter(view -> this.isPermitted("view:read", view.id()) || view.type().equals((Object)ViewDTO.Type.DASHBOARD) && this.isPermitted("dashboards:read", view.id())).collect(Collectors.toSet());
    }
}

