/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.processing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import javax.annotation.Nullable;
import org.graylog2.plugin.lifecycles.Lifecycle;
import org.graylog2.system.processing.AutoValue_ProcessingStatusDto;
import org.graylog2.system.processing.AutoValue_ProcessingStatusDto_JournalInfo;
import org.graylog2.system.processing.AutoValue_ProcessingStatusDto_ReceiveTimes;
import org.graylog2.system.processing.ProcessingStatusRecorder;
import org.joda.time.DateTime;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class ProcessingStatusDto {
    private static final String FIELD_ID = "id";
    static final String FIELD_NODE_ID = "node_id";
    static final String FIELD_NODE_LIFECYCLE_STATUS = "node_lifecycle_status";
    static final String FIELD_UPDATED_AT = "updated_at";
    static final String FIELD_RECEIVE_TIMES = "receive_times";
    static final String FIELD_INPUT_JOURNAL = "input_journal";

    @Id
    @ObjectId
    @Nullable
    @JsonProperty(value="id")
    public abstract String id();

    @JsonProperty(value="node_id")
    public abstract String nodeId();

    @JsonProperty(value="node_lifecycle_status")
    public abstract Lifecycle nodeLifecycleStatus();

    @JsonProperty(value="updated_at")
    public abstract DateTime updatedAt();

    @JsonProperty(value="receive_times")
    public abstract ReceiveTimes receiveTimes();

    @JsonProperty(value="input_journal")
    public abstract JournalInfo inputJournal();

    public static ProcessingStatusDto of(String nodeId, ProcessingStatusRecorder processingStatusRecorder, DateTime updatedAt, boolean messageJournalEnabled) {
        return ProcessingStatusDto.builder().nodeId(nodeId).updatedAt(updatedAt).nodeLifecycleStatus(processingStatusRecorder.getNodeLifecycleStatus()).receiveTimes(ReceiveTimes.builder().ingest(processingStatusRecorder.getIngestReceiveTime()).postProcessing(processingStatusRecorder.getPostProcessingReceiveTime()).postIndexing(processingStatusRecorder.getPostIndexingReceiveTime()).build()).inputJournal(JournalInfo.builder().uncommittedEntries(processingStatusRecorder.getJournalInfoUncommittedEntries()).readMessages1mRate(processingStatusRecorder.getJournalInfoReadMessages1mRate()).writtenMessages1mRate(processingStatusRecorder.getJournalInfoWrittenMessages1mRate()).journalEnabled(messageJournalEnabled).build()).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @JsonDeserialize(builder=Builder.class)
    @AutoValue
    public static abstract class JournalInfo {
        static final String FIELD_UNCOMMITTED_ENTRIES = "uncommitted_entries";
        private static final String FIELD_READ_MESSAGES_1M_RATE = "read_messages_1m_rate";
        static final String FIELD_WRITTEN_MESSAGES_1M_RATE = "written_messages_1m_rate";
        static final String FIELD_JOURNAL_ENABLED = "journal_enabled";

        @JsonProperty(value="uncommitted_entries")
        public abstract long uncommittedEntries();

        @JsonProperty(value="read_messages_1m_rate")
        public abstract double readMessages1mRate();

        @JsonProperty(value="written_messages_1m_rate")
        public abstract double writtenMessages1mRate();

        @JsonProperty(value="journal_enabled")
        public abstract boolean journalEnabled();

        public static Builder builder() {
            return Builder.create();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonCreator
            public static Builder create() {
                return new AutoValue_ProcessingStatusDto_JournalInfo.Builder().uncommittedEntries(0L).readMessages1mRate(0.0).writtenMessages1mRate(0.0).journalEnabled(true);
            }

            @JsonProperty(value="uncommitted_entries")
            public abstract Builder uncommittedEntries(long var1);

            @JsonProperty(value="read_messages_1m_rate")
            public abstract Builder readMessages1mRate(double var1);

            @JsonProperty(value="written_messages_1m_rate")
            public abstract Builder writtenMessages1mRate(double var1);

            @JsonProperty(value="journal_enabled")
            public abstract Builder journalEnabled(boolean var1);

            public abstract JournalInfo build();
        }
    }

    @JsonDeserialize(builder=Builder.class)
    @AutoValue
    public static abstract class ReceiveTimes {
        private static final String FIELD_INGEST = "ingest";
        private static final String FIELD_POST_PROCESSING = "post_processing";
        static final String FIELD_POST_INDEXING = "post_indexing";

        @JsonProperty(value="ingest")
        public abstract DateTime ingest();

        @JsonProperty(value="post_processing")
        public abstract DateTime postProcessing();

        @JsonProperty(value="post_indexing")
        public abstract DateTime postIndexing();

        public static Builder builder() {
            return Builder.create();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonCreator
            public static Builder create() {
                return new AutoValue_ProcessingStatusDto_ReceiveTimes.Builder();
            }

            @JsonProperty(value="ingest")
            public abstract Builder ingest(DateTime var1);

            @JsonProperty(value="post_processing")
            public abstract Builder postProcessing(DateTime var1);

            @JsonProperty(value="post_indexing")
            public abstract Builder postIndexing(DateTime var1);

            public abstract ReceiveTimes build();
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_ProcessingStatusDto.Builder().nodeLifecycleStatus(Lifecycle.RUNNING).inputJournal(JournalInfo.builder().build());
        }

        @Id
        @ObjectId
        @JsonProperty(value="id")
        public abstract Builder id(String var1);

        @JsonProperty(value="node_id")
        public abstract Builder nodeId(String var1);

        @JsonProperty(value="node_lifecycle_status")
        public abstract Builder nodeLifecycleStatus(Lifecycle var1);

        @JsonProperty(value="updated_at")
        public abstract Builder updatedAt(DateTime var1);

        @JsonProperty(value="receive_times")
        public abstract Builder receiveTimes(ReceiveTimes var1);

        @JsonProperty(value="input_journal")
        public abstract Builder inputJournal(JournalInfo var1);

        public abstract ProcessingStatusDto build();
    }
}

