/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.netflow.utils;

import com.google.common.net.InetAddresses;
import io.netty.buffer.ByteBuf;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ByteBufUtils {
    public static final InetAddress DEFAULT_INET_ADDRESS = InetAddresses.forString((String)"0.0.0.0");

    public static long getUnsignedInteger(ByteBuf buf, int offset, int length) {
        switch (length) {
            case 1: {
                return buf.getUnsignedByte(offset);
            }
            case 2: {
                return buf.getUnsignedShort(offset);
            }
            case 3: {
                return buf.getUnsignedMedium(offset);
            }
            case 4: {
                return buf.getUnsignedInt(offset);
            }
            case 8: {
                return buf.getLong(offset) & 0xFFFFFFFFL;
            }
        }
        return 0L;
    }

    public static InetAddress getInetAddress(ByteBuf buf, int offset, int length) {
        byte[] data = new byte[length];
        buf.getBytes(offset, data, 0, length);
        return ByteBufUtils.getInetAddress(data);
    }

    public static InetAddress readInetAddress(ByteBuf buf) {
        byte[] data = new byte[4];
        buf.readBytes(data);
        return ByteBufUtils.getInetAddress(data);
    }

    private static InetAddress getInetAddress(byte[] data) {
        InetAddress address;
        try {
            address = InetAddress.getByAddress(data);
        }
        catch (UnknownHostException e) {
            address = DEFAULT_INET_ADDRESS;
        }
        return address;
    }
}

