/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.messageq;

import com.google.inject.Module;
import com.google.inject.Scopes;
import org.graylog2.Configuration;
import org.graylog2.plugin.PluginModule;
import org.graylog2.shared.journal.Journal;
import org.graylog2.shared.journal.LocalKafkaJournal;
import org.graylog2.shared.journal.LocalKafkaJournalModule;
import org.graylog2.shared.journal.NoopJournal;
import org.graylog2.shared.messageq.MessageQueueAcknowledger;
import org.graylog2.shared.messageq.MessageQueueReader;
import org.graylog2.shared.messageq.MessageQueueWriter;
import org.graylog2.shared.messageq.localkafka.LocalKafkaMessageQueueAcknowledger;
import org.graylog2.shared.messageq.localkafka.LocalKafkaMessageQueueReader;
import org.graylog2.shared.messageq.localkafka.LocalKafkaMessageQueueWriter;
import org.graylog2.shared.messageq.noop.NoopMessageQueueAcknowledger;
import org.graylog2.shared.messageq.noop.NoopMessageQueueReader;
import org.graylog2.shared.messageq.noop.NoopMessageQueueWriter;

public class MessageQueueModule
extends PluginModule {
    public static final String DISK_JOURNAL_MODE = "disk";
    public static final String NOOP_JOURNAL_MODE = "noop";
    private final Configuration configuration;

    public MessageQueueModule(Configuration configuration) {
        this.configuration = configuration;
    }

    protected void configure() {
        switch (this.configuration.getMessageJournalMode()) {
            case "noop": {
                this.bindMessageQueueImplementation(NoopMessageQueueReader.class, NoopMessageQueueWriter.class, NoopMessageQueueAcknowledger.class);
                break;
            }
            case "disk": {
                this.bindMessageQueueImplementation(LocalKafkaMessageQueueReader.class, LocalKafkaMessageQueueWriter.class, LocalKafkaMessageQueueAcknowledger.class);
                break;
            }
        }
        if (this.configuration.getMessageJournalMode().equals(DISK_JOURNAL_MODE)) {
            this.install((Module)new LocalKafkaJournalModule());
            this.serviceBinder().addBinding().to(LocalKafkaJournal.class).in(Scopes.SINGLETON);
        } else {
            this.binder().bind(Journal.class).to(NoopJournal.class).in(Scopes.SINGLETON);
            this.serviceBinder().addBinding().to(NoopJournal.class).in(Scopes.SINGLETON);
        }
        this.bind(MessageQueueReader.Metrics.class).toProvider(MessageQueueReader.Metrics.Provider.class).in(Scopes.SINGLETON);
        this.bind(MessageQueueWriter.Metrics.class).toProvider(MessageQueueWriter.Metrics.Provider.class).in(Scopes.SINGLETON);
        this.bind(MessageQueueAcknowledger.Metrics.class).toProvider(MessageQueueAcknowledger.Metrics.Provider.class).in(Scopes.SINGLETON);
    }
}

