/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security;

import java.lang.reflect.Method;
import javax.inject.Inject;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.shared.security.RestrictToMaster;
import org.graylog2.shared.security.RestrictToMasterFilter;

public class RestrictToMasterFeature
implements DynamicFeature {
    private final ServerStatus serverStatus;
    private final RestrictToMasterFilter restrictToMasterFilter;

    @Inject
    public RestrictToMasterFeature(ServerStatus serverStatus) {
        this.serverStatus = serverStatus;
        this.restrictToMasterFilter = new RestrictToMasterFilter();
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        Class resourceClass = resourceInfo.getResourceClass();
        Method resourceMethod = resourceInfo.getResourceMethod();
        if (this.serverStatus.hasCapability(ServerStatus.Capability.MASTER)) {
            return;
        }
        if (resourceMethod.isAnnotationPresent(RestrictToMaster.class) || resourceClass.isAnnotationPresent(RestrictToMaster.class)) {
            context.register((Object)this.restrictToMasterFilter);
        }
    }
}

