/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.traffic;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.system.traffic.AutoValue_TrafficCounterService_TrafficHistogram;
import org.graylog2.system.traffic.TrafficDto;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBUpdate;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;
import org.mongojack.internal.update.SingleUpdateOperationValue;
import org.mongojack.internal.update.UpdateOperationValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrafficCounterService {
    private static final Logger LOG = LoggerFactory.getLogger(TrafficCounterService.class);
    private static final String BUCKET = "bucket";
    private final JacksonDBCollection<TrafficDto, ObjectId> db;

    @Inject
    public TrafficCounterService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        this.db = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection("traffic"), TrafficDto.class, ObjectId.class, (ObjectMapper)mapper.get());
        this.db.createIndex((DBObject)new BasicDBObject(BUCKET, (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
    }

    private static DateTime getDayBucket(DateTime observationTime) {
        return observationTime.withHourOfDay(0).withMinuteOfHour(0).withSecondOfMinute(0).withMillisOfSecond(0);
    }

    private static DateTime getHourBucket(DateTime observationTime) {
        return observationTime.withMinuteOfHour(0).withSecondOfMinute(0).withMillisOfSecond(0);
    }

    public void updateTraffic(DateTime observationTime, NodeId nodeId, long inLastMinute, long outLastMinute, long decodedLastMinute) {
        WriteResult update;
        DateTime dayBucket = TrafficCounterService.getHourBucket(observationTime);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating traffic for node {} at {}:  in/decoded/out {}/{}/{} bytes", new Object[]{nodeId.toString(), dayBucket, inLastMinute, decodedLastMinute, outLastMinute});
        }
        if ((update = this.db.update(DBQuery.is((String)BUCKET, (Object)dayBucket), new DBUpdate.Builder().addOperation("$inc", "input." + nodeId.toString(), (UpdateOperationValue)new SingleUpdateOperationValue(false, false, (Object)inLastMinute)).addOperation("$inc", "output." + nodeId.toString(), (UpdateOperationValue)new SingleUpdateOperationValue(false, false, (Object)outLastMinute)).addOperation("$inc", "decoded." + nodeId.toString(), (UpdateOperationValue)new SingleUpdateOperationValue(false, false, (Object)decodedLastMinute)), true, false)).getN() == 0) {
            LOG.warn("Unable to update traffic of node {}: {}", (Object)nodeId, (Object)update);
        }
    }

    public TrafficHistogram clusterTrafficOfLastDays(Duration duration, Interval interval) {
        ImmutableMap.Builder inputBuilder = ImmutableMap.builder();
        ImmutableMap.Builder outputBuilder = ImmutableMap.builder();
        ImmutableMap.Builder decodedBuilder = ImmutableMap.builder();
        DateTime to = Tools.nowUTC();
        DateTime from = TrafficCounterService.getDayBucket(to).minus((ReadableDuration)duration);
        DBQuery.Query query = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.lessThanEquals((String)BUCKET, (Object)to), DBQuery.greaterThanEquals((String)BUCKET, (Object)from)});
        try (DBCursor cursor = this.db.find(query);){
            cursor.forEach(trafficDto -> {
                inputBuilder.put((Object)trafficDto.bucket(), (Object)trafficDto.input().values().stream().mapToLong(Long::valueOf).sum());
                outputBuilder.put((Object)trafficDto.bucket(), (Object)trafficDto.output().values().stream().mapToLong(Long::valueOf).sum());
                decodedBuilder.put((Object)trafficDto.bucket(), (Object)trafficDto.decoded().values().stream().mapToLong(Long::valueOf).sum());
            });
            Object inputHistogram = inputBuilder.build();
            Object outputHistogram = outputBuilder.build();
            Object decodedHistogram = decodedBuilder.build();
            if (interval == Interval.DAILY) {
                inputHistogram = this.aggregateToDaily((Map<DateTime, Long>)inputHistogram);
                outputHistogram = this.aggregateToDaily((Map<DateTime, Long>)outputHistogram);
                decodedHistogram = this.aggregateToDaily((Map<DateTime, Long>)decodedHistogram);
            }
            TrafficHistogram trafficHistogram = TrafficHistogram.create(from, to, (Map<DateTime, Long>)inputHistogram, (Map<DateTime, Long>)outputHistogram, (Map<DateTime, Long>)decodedHistogram);
            return trafficHistogram;
        }
    }

    private TreeMap<DateTime, Long> aggregateToDaily(Map<DateTime, Long> histogram) {
        return histogram.entrySet().stream().collect(Collectors.groupingBy(entry -> ((DateTime)entry.getKey()).withTimeAtStartOfDay(), TreeMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.summingLong(Long::valueOf))));
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class TrafficHistogram {
        @JsonCreator
        public static TrafficHistogram create(@JsonProperty(value="from") DateTime from, @JsonProperty(value="to") DateTime to, @JsonProperty(value="input") Map<DateTime, Long> input, @JsonProperty(value="output") Map<DateTime, Long> output, @JsonProperty(value="decoded") Map<DateTime, Long> decoded) {
            return new AutoValue_TrafficCounterService_TrafficHistogram(from, to, input, output, decoded);
        }

        @JsonProperty
        public abstract DateTime from();

        @JsonProperty
        public abstract DateTime to();

        @JsonProperty
        public abstract Map<DateTime, Long> input();

        @JsonProperty
        public abstract Map<DateTime, Long> output();

        @JsonProperty
        public abstract Map<DateTime, Long> decoded();
    }

    public static enum Interval {
        HOURLY,
        DAILY;

    }
}

